/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hive.hplsql.Conn;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Utils;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.executor.QueryException;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.executor.QueryResult;
import org.apache.hive.hplsql.functions.BuiltinFunctions;
import org.apache.hive.hplsql.functions.FunctionDatetime;

public class FunctionMisc
extends BuiltinFunctions {
    public FunctionMisc(Exec e, QueryExecutor queryExecutor) {
        super(e, queryExecutor);
    }

    @Override
    public void register(BuiltinFunctions f) {
        f.map.put("COALESCE", this::nvl);
        f.map.put("DECODE", this::decode);
        f.map.put("NVL", this::nvl);
        f.map.put("NVL2", this::nvl2);
        f.map.put("PART_COUNT_BY", this::partCountBy);
        f.map.put("MOD", this::modulo);
        f.specMap.put("ACTIVITY_COUNT", this::activityCount);
        f.specMap.put("CAST", this::cast);
        f.specMap.put("CURRENT", this::current);
        f.specMap.put("CURRENT_USER", this::currentUser);
        f.specMap.put("PART_COUNT", this::partCount);
        f.specMap.put("USER", this::currentUser);
        f.specSqlMap.put("CURRENT", this::currentSql);
    }

    void activityCount(HplsqlParser.Expr_spec_funcContext ctx) {
        this.evalInt(Long.valueOf(this.exec.getRowCount()));
    }

    void cast(HplsqlParser.Expr_spec_funcContext ctx) {
        String valueUpper;
        if (ctx.expr().size() != 1) {
            this.evalNull();
            return;
        }
        String type = ctx.dtype().getText();
        String len = null;
        String scale = null;
        if (ctx.dtype_len() != null) {
            len = ctx.dtype_len().L_INT(0).getText();
            if (ctx.dtype_len().L_INT(1) != null) {
                scale = ctx.dtype_len().L_INT(1).getText();
            }
        }
        Var var = new Var(null, type, len, scale, null);
        Var value = this.evalPop(ctx.expr(0));
        if (value.type == Var.Type.STRING) {
            Var newValue;
            value = newValue = new Var(value.name, value.type, Utils.unquoteString(value.toString()));
        }
        if (value.type != Var.Type.NULL && ((valueUpper = value.toString().toUpperCase()).startsWith("TIMESTAMP ") || valueUpper.startsWith("DATE "))) {
            boolean old = this.exec.buildSql;
            this.exec.buildSql = false;
            value = this.evalPop(ctx.expr(0));
            this.exec.buildSql = old;
        }
        var.cast(value);
        if (this.exec.buildSql && var.type == Var.Type.STRING) {
            this.evalString(var.toSqlString());
        } else {
            this.evalVar(var);
        }
    }

    void current(HplsqlParser.Expr_spec_funcContext ctx) {
        if (ctx.T_DATE() != null) {
            this.evalVar(FunctionDatetime.currentDate());
        } else if (ctx.T_TIMESTAMP() != null) {
            int precision = this.evalPop(ctx.expr(0), 3).intValue();
            this.evalVar(FunctionDatetime.currentTimestamp(precision));
        } else if (ctx.T_USER() != null) {
            this.evalVar(this.currentUser());
        } else {
            this.evalNull();
        }
    }

    void currentSql(HplsqlParser.Expr_spec_funcContext ctx) {
        if (ctx.T_DATE() != null) {
            if (this.exec.getConnectionType() == Conn.Type.HIVE) {
                this.evalSqlString("TO_DATE(FROM_UNIXTIME(UNIX_TIMESTAMP()))");
            } else {
                this.evalSqlString("CURRENT_DATE");
            }
        } else if (ctx.T_TIMESTAMP() != null) {
            if (this.exec.getConnectionType() == Conn.Type.HIVE) {
                this.evalSqlString("FROM_UNIXTIME(UNIX_TIMESTAMP())");
            } else {
                this.evalSqlString("CURRENT_TIMESTAMP");
            }
        } else if (ctx.T_USER() != null) {
            this.evalSqlString("CURRENT_USER()");
        } else {
            this.evalSqlString(Exec.getFormattedText(ctx));
        }
    }

    void currentUser(HplsqlParser.Expr_spec_funcContext ctx) {
        this.evalVar(this.currentUser());
    }

    public Var currentUser() {
        String currentUser = System.getProperty("user.name");
        return new Var(currentUser);
    }

    void decode(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = ctx.func_param().size();
        if (cnt < 3) {
            this.evalNull();
            return;
        }
        Var value = this.evalPop(ctx.func_param(0).expr());
        int i = 1;
        while (i + 1 < cnt) {
            Var when = this.evalPop(ctx.func_param(i).expr());
            if (value.isNull() && when.isNull() || value.equals(when)) {
                this.eval(ctx.func_param(i + 1).expr());
                return;
            }
            i += 2;
        }
        if (i < cnt) {
            this.eval(ctx.func_param(i).expr());
        } else {
            this.evalNull();
        }
    }

    void nvl(HplsqlParser.Expr_func_paramsContext ctx) {
        for (int i = 0; i < ctx.func_param().size(); ++i) {
            Var v = this.evalPop(ctx.func_param(i).expr());
            if (v.type == Var.Type.NULL) continue;
            this.exec.stackPush(v);
            return;
        }
        this.evalNull();
    }

    void nvl2(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() == 3) {
            Var firstParam = this.evalPop(ctx.func_param(0).expr());
            if (!firstParam.isNull()) {
                this.eval(ctx.func_param(1).expr());
            } else {
                this.eval(ctx.func_param(2).expr());
            }
        } else {
            this.evalNull();
        }
    }

    public void partCount(HplsqlParser.Expr_spec_funcContext ctx) {
        String tabname = this.evalPop(ctx.expr(0)).toString();
        StringBuilder sql = new StringBuilder();
        sql.append("SHOW PARTITIONS ");
        sql.append(tabname);
        int cnt = ctx.expr().size();
        if (cnt > 1) {
            sql.append(" PARTITION (");
            int i = 1;
            while (i + 1 < cnt) {
                String col = this.evalPop(ctx.expr(i)).toString();
                String val = this.evalPop(ctx.expr(i + 1)).toSqlString();
                if (i > 2) {
                    sql.append(", ");
                }
                sql.append(col);
                sql.append("=");
                sql.append(val);
                i += 2;
            }
            sql.append(")");
        }
        if (this.trace) {
            this.trace(ctx, "Query: " + String.valueOf(sql));
        }
        if (this.exec.getOffline()) {
            this.evalNull();
            return;
        }
        QueryResult query = this.queryExecutor.executeQuery(sql.toString(), ctx);
        if (query.error()) {
            this.evalNullClose(query);
            return;
        }
        int result = 0;
        try {
            while (query.next()) {
                ++result;
            }
        }
        catch (Exception e) {
            this.evalNullClose(query);
            return;
        }
        this.evalInt(result);
        query.close();
    }

    public void modulo(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() == 2) {
            int a = this.evalPop(ctx.func_param(0).expr()).intValue();
            int b = this.evalPop(ctx.func_param(1).expr()).intValue();
            this.evalInt(a % b);
        } else {
            this.evalNull();
        }
    }

    public void partCountBy(HplsqlParser.Expr_func_paramsContext ctx) {
        String sql;
        QueryResult query;
        int cnt = ctx.func_param().size();
        if (cnt < 1 || this.exec.getOffline()) {
            return;
        }
        String tabname = this.evalPop(ctx.func_param(0).expr()).toString();
        ArrayList<String> keys = null;
        if (cnt > 1) {
            keys = new ArrayList<String>();
            for (int i = 1; i < cnt; ++i) {
                keys.add(this.evalPop(ctx.func_param(i).expr()).toString().toUpperCase());
            }
        }
        if ((query = this.queryExecutor.executeQuery(sql = "SHOW PARTITIONS " + tabname, ctx)).error()) {
            query.close();
            return;
        }
        HashMap<String, Integer> group = new HashMap<String, Integer>();
        try {
            while (query.next()) {
                Integer count;
                String part = query.column(0, String.class);
                String[] parts = part.split("/");
                String key = parts[0];
                if (cnt > 1) {
                    StringBuilder k = new StringBuilder();
                    for (int i = 0; i < parts.length; ++i) {
                        if (!keys.contains(parts[i].split("=")[0].toUpperCase())) continue;
                        if (k.length() > 0) {
                            k.append("/");
                        }
                        k.append(parts[i]);
                    }
                    key = k.toString();
                }
                if ((count = (Integer)group.get(key)) == null) {
                    count = 0;
                }
                group.put(key, count + 1);
            }
        }
        catch (QueryException e) {
            query.close();
            return;
        }
        if (cnt == 1) {
            this.evalInt(group.size());
        } else {
            for (Map.Entry i : group.entrySet()) {
                this.console.printLine((String)i.getKey() + "\t" + String.valueOf(i.getValue()));
            }
        }
        query.close();
    }
}

