/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class LongStringConverter
implements TypeConverter<Long, String> {
    private static final long serialVersionUID = -4708086231754476616L;

    @Override
    public Long toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Long.getLong(str);
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, Long.class.getName()), nfe);
        }
    }

    @Override
    public String toDatastoreType(Long val) {
        if (val == null) {
            return null;
        }
        return val.toString();
    }
}

