/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlanForClass;
import org.datanucleus.FetchPlanState;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.AbstractFetchDepthFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.TypeManager;

public class LoadFieldManager
extends AbstractFetchDepthFieldManager {
    public LoadFieldManager(DNStateManager sm, boolean[] secondClassMutableFields, FetchPlanForClass fpClass, FetchPlanState state) {
        super(sm, secondClassMutableFields, fpClass, state);
    }

    protected void processPersistable(Object pc) {
        ExecutionContext ec = this.sm.getExecutionContext().getApiAdapter().getExecutionContext(pc);
        if (ec != null) {
            ec.findStateManager(pc).loadFieldsInFetchPlan(this.state);
        }
    }

    @Override
    protected Object internalFetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd;
        RelationType relationType;
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        if (value != null && (relationType = (mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber)).getRelationType(this.sm.getExecutionContext().getClassLoaderResolver())) != RelationType.NONE) {
            if (mmd.hasContainer()) {
                value = this.processContainer(mmd, value);
            } else {
                this.processPersistable(value);
            }
        }
        return value;
    }

    private Object processContainer(AbstractMemberMetaData mmd, Object container) {
        Object wrappedContainer = container;
        if (mmd.hasArray()) {
            wrappedContainer = container;
        } else if (!(container instanceof SCO)) {
            wrappedContainer = SCOUtils.wrapSCOField(this.sm, mmd.getAbsoluteFieldNumber(), container, true);
        }
        ExecutionContext ec = this.sm.getExecutionContext();
        TypeManager typeManager = ec.getTypeManager();
        Object containerHandler = typeManager.getContainerHandler(mmd.getType());
        ApiAdapter api = ec.getApiAdapter();
        for (Object object : containerHandler.getAdapter((Object)wrappedContainer)) {
            if (!api.isPersistable(object)) continue;
            this.processPersistable(object);
        }
        return wrappedContainer;
    }

    @Override
    protected Object endOfGraphOperation(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        return value;
    }
}

