/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.FieldValues;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class StateManagerFactoryImpl
implements StateManagerFactory {
    Class<? extends DNStateManager> smClass = null;
    public static final Class[] STATE_MANAGER_CTR_ARG_CLASSES = new Class[]{ClassConstants.EXECUTION_CONTEXT, AbstractClassMetaData.class};
    private volatile Set<Class<?>> initializedPcClasses = Collections.emptySet();

    public StateManagerFactoryImpl(PersistenceNucleusContext nucCtx) {
        String smClassName = nucCtx.getConfiguration().getStringProperty("datanucleus.statemanager.classname");
        if (StringUtils.isWhitespace(smClassName)) {
            smClassName = nucCtx.getStoreManager().getDefaultStateManagerClassName();
        }
        this.smClass = nucCtx.getClassLoaderResolver(null).classForName(smClassName);
    }

    @Override
    public void close() {
    }

    @Override
    public <T> DNStateManager<T> newForHollow(ExecutionContext ec, Class<T> pcClass, Object id) {
        Class cls = this.getInitialisedClassForClass(pcClass, ec.getClassLoaderResolver());
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pcClass, ec.getClassLoaderResolver());
        DNStateManager sm = this.getStateManager(ec, cmd);
        sm.initialiseForHollow(id, null, cls);
        return sm;
    }

    @Override
    public <T> DNStateManager<T> newForHollow(ExecutionContext ec, Class<T> pcClass, Object id, FieldValues fv) {
        Class cls = this.getInitialisedClassForClass(pcClass, ec.getClassLoaderResolver());
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pcClass, ec.getClassLoaderResolver());
        DNStateManager sm = this.getStateManager(ec, cmd);
        sm.initialiseForHollow(id, fv, cls);
        return sm;
    }

    @Override
    public <T> DNStateManager<T> newForHollowPreConstructed(ExecutionContext ec, Object id, T pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        DNStateManager sm = this.getStateManager(ec, cmd);
        sm.initialiseForHollowPreConstructed(id, pc);
        return sm;
    }

    @Override
    @Deprecated
    public <T> DNStateManager<T> newForHollowPopulatedAppId(ExecutionContext ec, Class<T> pcClass, FieldValues fv) {
        Class cls = this.getInitialisedClassForClass(pcClass, ec.getClassLoaderResolver());
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pcClass, ec.getClassLoaderResolver());
        DNStateManager sm = this.getStateManager(ec, cmd);
        sm.initialiseForHollowAppId(fv, cls);
        return sm;
    }

    @Override
    public <T> DNStateManager<T> newForPersistentClean(ExecutionContext ec, Object id, T pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        DNStateManager sm = this.getStateManager(ec, cmd);
        sm.initialiseForPersistentClean(id, pc);
        return sm;
    }

    @Override
    public <T> DNStateManager<T> newForEmbedded(ExecutionContext ec, T pc, boolean copyPc, DNStateManager ownerSM, int ownerMemberNumber, PersistableObjectType objectType) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        DNStateManager sm = this.getStateManager(ec, cmd);
        sm.initialiseForEmbedded(pc, copyPc);
        if (ownerSM != null) {
            ec.registerEmbeddedRelation(ownerSM, ownerMemberNumber, objectType, sm);
        }
        return sm;
    }

    @Override
    public DNStateManager newForEmbedded(ExecutionContext ec, AbstractClassMetaData cmd, DNStateManager ownerSM, int ownerMemberNumber, PersistableObjectType objectType) {
        Class pcClass = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Class cls = this.getInitialisedClassForClass(pcClass, ec.getClassLoaderResolver());
        DNStateManager sm = this.getStateManager(ec, cmd);
        sm.initialiseForEmbedded(cls);
        if (ownerSM != null) {
            ec.registerEmbeddedRelation(ownerSM, ownerMemberNumber, objectType, sm);
        }
        return sm;
    }

    @Override
    public <T> DNStateManager<T> newForPersistentNew(ExecutionContext ec, T pc, FieldValues preInsertChanges) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        DNStateManager sm = this.getStateManager(ec, cmd);
        sm.initialiseForPersistentNew(pc, preInsertChanges);
        return sm;
    }

    @Override
    public <T> DNStateManager<T> newForTransactionalTransient(ExecutionContext ec, T pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        DNStateManager sm = this.getStateManager(ec, cmd);
        sm.initialiseForTransactionalTransient(pc);
        return sm;
    }

    @Override
    public <T> DNStateManager<T> newForDetached(ExecutionContext ec, T pc, Object id, Object version) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        DNStateManager sm = this.getStateManager(ec, cmd);
        sm.initialiseForDetached(pc, id, version);
        return sm;
    }

    @Override
    public <T> DNStateManager<T> newForPNewToBeDeleted(ExecutionContext ec, T pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        DNStateManager sm = this.getStateManager(ec, cmd);
        sm.initialiseForPNewToBeDeleted(pc);
        return sm;
    }

    @Override
    public <T> DNStateManager<T> newForCachedPC(ExecutionContext ec, Object id, CachedPC cachedPC) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(cachedPC.getObjectClass(), ec.getClassLoaderResolver());
        DNStateManager sm = this.getStateManager(ec, cmd);
        sm.initialiseForCachedPC(cachedPC, id);
        return sm;
    }

    @Override
    public void disconnectStateManager(DNStateManager sm) {
    }

    protected DNStateManager getStateManager(ExecutionContext ec, AbstractClassMetaData cmd) {
        return ClassUtils.newInstance(this.smClass, STATE_MANAGER_CTR_ARG_CLASSES, new Object[]{ec, cmd});
    }

    private Class getInitialisedClassForClass(Class pcCls, ClassLoaderResolver clr) {
        try {
            if (this.initializedPcClasses.contains(pcCls)) {
                return pcCls;
            }
            HashSet updated = new HashSet(this.initializedPcClasses);
            Class resolved = clr.classForName(pcCls.getName(), pcCls.getClassLoader(), true);
            if (resolved != pcCls) {
                throw new IllegalStateException();
            }
            updated.add(pcCls);
            this.initializedPcClasses = updated;
            return pcCls;
        }
        catch (ClassNotResolvedException e) {
            throw new NucleusUserException(Localiser.msg("026015", pcCls.getName())).setFatal();
        }
    }
}

