/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.flush;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.flush.FlushProcess;
import org.datanucleus.flush.OperationQueue;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class FlushNonReferential
implements FlushProcess {
    @Override
    public List<NucleusOptimisticException> execute(ExecutionContext ec, Collection<DNStateManager> primarySMs, Collection<DNStateManager> secondarySMs, OperationQueue opQueue) {
        HashSet<DNStateManager> smsToFlush = new HashSet<DNStateManager>();
        if (primarySMs != null) {
            smsToFlush.addAll(primarySMs);
            primarySMs.clear();
        }
        if (secondarySMs != null) {
            smsToFlush.addAll(secondarySMs);
            secondarySMs.clear();
        }
        List<NucleusOptimisticException> excptns = this.flushDeleteInsertUpdateGrouped(smsToFlush, ec);
        if (opQueue != null) {
            if (!ec.getStoreManager().usesBackedSCOWrappers()) {
                opQueue.processOperationsForNoBackingStoreSCOs(ec);
            }
            opQueue.clearPersistDeleteUpdateOperations();
        }
        return excptns;
    }

    public List<NucleusOptimisticException> flushDeleteInsertUpdateGrouped(Set<DNStateManager> smsToFlush, ExecutionContext ec) {
        ArrayList<NucleusOptimisticException> optimisticFailures = null;
        HashSet classesToFlush = null;
        if (ec.getNucleusContext().getStoreManager().getQueryManager().getQueryResultsCache() != null) {
            classesToFlush = new HashSet();
        }
        HashSet<DNStateManager> smsToDelete = new HashSet<DNStateManager>();
        HashSet<DNStateManager> smsToInsert = new HashSet<DNStateManager>();
        Iterator<DNStateManager> smIter = smsToFlush.iterator();
        while (smIter.hasNext()) {
            DNStateManager sm = smIter.next();
            if (sm.isEmbedded()) {
                sm.markAsFlushed();
                smIter.remove();
                continue;
            }
            if (classesToFlush != null && sm.getObject() != null) {
                classesToFlush.add(sm.getObject().getClass());
            }
            if (sm.getLifecycleState().isNew() && !sm.isFlushedToDatastore() && !sm.isFlushedNew()) {
                smsToInsert.add(sm);
                smIter.remove();
                continue;
            }
            if (!sm.getLifecycleState().isDeleted() || sm.isFlushedToDatastore()) continue;
            if (!sm.getLifecycleState().isNew()) {
                smsToDelete.add(sm);
                smIter.remove();
                continue;
            }
            if (!sm.getLifecycleState().isNew() || !sm.isFlushedNew()) continue;
            smsToDelete.add(sm);
            smIter.remove();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("010046", smsToDelete.size(), smsToInsert.size(), smsToFlush.size()));
        }
        StorePersistenceHandler persistenceHandler = ec.getStoreManager().getPersistenceHandler();
        if (!smsToDelete.isEmpty()) {
            for (DNStateManager dNStateManager : smsToDelete) {
                dNStateManager.setFlushing(true);
                ec.getCallbackHandler().preDelete(dNStateManager.getObject());
            }
            try {
                persistenceHandler.deleteObjects(smsToDelete.toArray(new DNStateManager[smsToDelete.size()]));
            }
            catch (NucleusOptimisticException noe) {
                optimisticFailures = new ArrayList<NucleusOptimisticException>();
                Throwable[] throwableArray = noe.getNestedExceptions();
                if (throwableArray != null && throwableArray.length > 1) {
                    NucleusOptimisticException[] noes = (NucleusOptimisticException[])throwableArray;
                    for (int i = 0; i < throwableArray.length; ++i) {
                        optimisticFailures.add(noes[i]);
                    }
                }
                optimisticFailures.add(noe);
            }
            for (DNStateManager dNStateManager : smsToDelete) {
                ec.getCallbackHandler().postDelete(dNStateManager.getObject());
                dNStateManager.setFlushedNew(false);
                dNStateManager.markAsFlushed();
                dNStateManager.setFlushing(false);
            }
        }
        if (!smsToInsert.isEmpty()) {
            for (DNStateManager dNStateManager : smsToInsert) {
                dNStateManager.setFlushing(true);
                ec.getCallbackHandler().preStore(dNStateManager.getObject());
            }
            persistenceHandler.insertObjects(smsToInsert.toArray(new DNStateManager[smsToInsert.size()]));
            for (DNStateManager dNStateManager : smsToInsert) {
                ec.getCallbackHandler().postStore(dNStateManager.getObject());
                dNStateManager.setFlushedNew(true);
                dNStateManager.markAsFlushed();
                dNStateManager.setFlushing(false);
                ec.putObjectIntoLevel1Cache(dNStateManager);
            }
        }
        if (!smsToFlush.isEmpty()) {
            for (DNStateManager dNStateManager : smsToFlush) {
                try {
                    dNStateManager.flush();
                }
                catch (NucleusOptimisticException oe) {
                    if (optimisticFailures == null) {
                        optimisticFailures = new ArrayList();
                    }
                    optimisticFailures.add(oe);
                }
            }
        }
        if (classesToFlush != null) {
            for (Class clazz : classesToFlush) {
                ec.getNucleusContext().getStoreManager().getQueryManager().evictQueryResultsForType(clazz);
            }
        }
        return optimisticFailures;
    }
}

