/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.exceptions.NucleusUserException;

public class EnhancementHelper {
    private static EnhancementHelper singletonHelper = new EnhancementHelper();
    private static Map<Class, Meta> registeredClasses = new ConcurrentHashMap<Class, Meta>();
    private static final List<RegisterClassListener> listeners = new ArrayList<RegisterClassListener>();

    private EnhancementHelper() {
    }

    public static EnhancementHelper getInstance() {
        return singletonHelper;
    }

    public Persistable newInstance(Class pcClass, StateManager sm) {
        Persistable pc = EnhancementHelper.getPersistableForClass(pcClass);
        return pc == null ? null : pc.dnNewInstance(sm);
    }

    public Persistable newInstance(Class pcClass, StateManager sm, Object oid) {
        Persistable pc = EnhancementHelper.getPersistableForClass(pcClass);
        return pc == null ? null : pc.dnNewInstance(sm, oid);
    }

    public Object newObjectIdInstance(Class pcClass) {
        Persistable pc = EnhancementHelper.getPersistableForClass(pcClass);
        return pc == null ? null : pc.dnNewObjectIdInstance();
    }

    public Object newObjectIdInstance(Class pcClass, Object obj) {
        Persistable pc = EnhancementHelper.getPersistableForClass(pcClass);
        return pc == null ? null : pc.dnNewObjectIdInstance(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClass(Class pcClass, Persistable pc) {
        if (pcClass == null) {
            throw new NullPointerException("Attempt to register class with null class type");
        }
        registeredClasses.put(pcClass, new Meta(pc));
        List<RegisterClassListener> list = listeners;
        synchronized (list) {
            if (!listeners.isEmpty()) {
                for (RegisterClassListener crl : listeners) {
                    if (crl == null) continue;
                    crl.registerClass(pcClass);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClasses(ClassLoader cl) {
        Map<Class, Meta> map = registeredClasses;
        synchronized (map) {
            Iterator<Class> i = registeredClasses.keySet().iterator();
            while (i.hasNext()) {
                Class pcClass = i.next();
                if (pcClass == null || pcClass.getClassLoader() != cl) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegisterClassListener(RegisterClassListener crl) {
        HashSet<Class> alreadyRegisteredClasses = null;
        List<RegisterClassListener> list = listeners;
        synchronized (list) {
            listeners.add(crl);
            alreadyRegisteredClasses = new HashSet<Class>(registeredClasses.keySet());
        }
        for (Class pcClass : alreadyRegisteredClasses) {
            crl.registerClass(pcClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegisterClassListener(RegisterClassListener crl) {
        List<RegisterClassListener> list = listeners;
        synchronized (list) {
            listeners.remove(crl);
        }
    }

    public Collection<Class> getRegisteredClasses() {
        return Collections.unmodifiableCollection(registeredClasses.keySet());
    }

    private static Persistable getPersistableForClass(Class pcClass) {
        Meta ret = registeredClasses.get(pcClass);
        if (ret == null) {
            throw new NucleusUserException("Cannot lookup meta info for " + pcClass + " - nothing found").setFatal();
        }
        return ret.getPC();
    }

    static class Meta {
        Persistable pc;

        Meta(Persistable pc) {
            this.pc = pc;
        }

        Persistable getPC() {
            return this.pc;
        }

        public String toString() {
            return "Meta-" + this.pc.getClass().getName();
        }
    }

    public static interface RegisterClassListener
    extends EventListener {
        public void registerClass(Class var1);
    }
}

