/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.NucleusContext;
import org.datanucleus.PropertyNames;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.properties.BooleanPropertyValidator;
import org.datanucleus.properties.FrequentlyAccessedProperties;
import org.datanucleus.properties.IntegerPropertyValidator;
import org.datanucleus.properties.PropertyStore;
import org.datanucleus.properties.PropertyValidator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class Configuration
extends PropertyStore
implements Serializable {
    private static final long serialVersionUID = 1483628590934722025L;
    private NucleusContext nucCtx;
    private Map<String, PropertyMapping> propertyMappings = new HashMap<String, PropertyMapping>();
    private Map<String, Object> defaultProperties = new HashMap<String, Object>();
    private Map<String, PropertyValidator> propertyValidators = new HashMap<String, PropertyValidator>();
    private volatile Map<String, Object> managerOverrideableProperties;
    private FrequentlyAccessedProperties defaultFrequentProperties = new FrequentlyAccessedProperties();

    public Configuration(NucleusContext nucCtx) {
        this.nucCtx = nucCtx;
        this.frequentProperties.setDefaults(this.defaultFrequentProperties);
        nucCtx.applyDefaultProperties(this);
        ConfigurationElement[] propElements = nucCtx.getPluginManager().getConfigurationElementsForExtension("org.datanucleus.persistence_properties", (String)null, (String)null);
        if (propElements != null) {
            for (int i = 0; i < propElements.length; ++i) {
                String name = propElements[i].getAttribute("name");
                String intName = propElements[i].getAttribute("internal-name");
                String value = propElements[i].getAttribute("value");
                String datastoreString = propElements[i].getAttribute("datastore");
                String validatorName = propElements[i].getAttribute("validator");
                boolean datastore = Boolean.valueOf(datastoreString);
                String mgrOverrideString = propElements[i].getAttribute("manager-overrideable");
                boolean mgrOverride = Boolean.valueOf(mgrOverrideString);
                this.addDefaultProperty(name, intName, value, validatorName, datastore, mgrOverride);
            }
        }
    }

    public Set<String> getSupportedProperties() {
        return this.propertyMappings.keySet();
    }

    public Map<String, Object> getDatastoreProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Map.Entry propEntry : this.properties.entrySet()) {
            String name = (String)propEntry.getKey();
            if (!this.isPropertyForDatastore(name)) continue;
            props.put(name, propEntry.getValue());
        }
        return props;
    }

    public void removeDatastoreProperties() {
        Iterator propKeyIter = this.properties.keySet().iterator();
        while (propKeyIter.hasNext()) {
            String name = (String)propKeyIter.next();
            if (!this.isPropertyForDatastore(name)) continue;
            propKeyIter.remove();
        }
    }

    private boolean isPropertyForDatastore(String name) {
        PropertyMapping mapping = this.propertyMappings.get(name);
        return mapping != null ? mapping.datastore : false;
    }

    public String getInternalNameForProperty(String name) {
        PropertyMapping mapping = this.propertyMappings.get(name);
        return mapping != null && mapping.internalName != null ? mapping.internalName : name;
    }

    public Map<String, Object> getManagerOverrideableProperties() {
        if (this.managerOverrideableProperties != null) {
            return this.managerOverrideableProperties;
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        for (PropertyMapping mapping : this.propertyMappings.values()) {
            PropertyMapping intMapping;
            if (mapping.managerOverride) {
                String propName = mapping.internalName != null ? mapping.internalName.toLowerCase() : mapping.name.toLowerCase();
                props.put(propName, this.getProperty(propName));
                continue;
            }
            if (mapping.internalName == null || (intMapping = this.propertyMappings.get(mapping.internalName.toLowerCase())) == null || !intMapping.managerOverride) continue;
            props.put(mapping.name.toLowerCase(), this.getProperty(mapping.internalName));
        }
        this.managerOverrideableProperties = Collections.unmodifiableMap(props);
        return this.managerOverrideableProperties;
    }

    public Set<String> getManagedOverrideablePropertyNames() {
        HashSet<String> propNames = new HashSet<String>();
        for (PropertyMapping mapping : this.propertyMappings.values()) {
            if (!mapping.managerOverride) continue;
            propNames.add(mapping.name);
        }
        return propNames;
    }

    public String getPropertyNameWithInternalPropertyName(String propName, String propPrefix) {
        if (propName == null) {
            return null;
        }
        for (PropertyMapping mapping : this.propertyMappings.values()) {
            if (mapping.internalName == null || !mapping.internalName.toLowerCase().equals(propName.toLowerCase()) || !mapping.name.startsWith(propPrefix)) continue;
            return mapping.name;
        }
        return null;
    }

    public String getCaseSensitiveNameForPropertyName(String propName) {
        if (propName == null) {
            return null;
        }
        for (PropertyMapping mapping : this.propertyMappings.values()) {
            if (!mapping.name.toLowerCase().equals(propName.toLowerCase())) continue;
            return mapping.name;
        }
        return propName;
    }

    public void setDefaultProperties(Map<String, Object> props) {
        if (props != null && !props.isEmpty()) {
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                String key = entry.getKey();
                String keyLC = key.toLowerCase();
                PropertyMapping mapping = this.propertyMappings.get(keyLC);
                Object propValue = entry.getValue();
                if (mapping != null && mapping.validatorName != null && propValue instanceof String) {
                    propValue = this.getValueForPropertyWithValidator((String)propValue, mapping.validatorName);
                }
                this.defaultProperties.put(keyLC, propValue);
                this.defaultFrequentProperties.setProperty(keyLC, propValue);
            }
        }
    }

    public void addDefaultBooleanProperty(String name, String internalName, Boolean value, boolean datastore, boolean managerOverrideable) {
        this.addDefaultProperty(name, internalName, value != null ? "" + value : null, BooleanPropertyValidator.class.getName(), datastore, managerOverrideable);
    }

    public void addDefaultIntegerProperty(String name, String internalName, Integer value, boolean datastore, boolean managerOverrideable) {
        this.addDefaultProperty(name, internalName, value != null ? "" + value : null, IntegerPropertyValidator.class.getName(), datastore, managerOverrideable);
    }

    public void addDefaultProperty(String name, String internalName, String value, String validatorName, boolean datastore, boolean managerOverrideable) {
        String storedName;
        this.managerOverrideableProperties = null;
        String nameLC = name.toLowerCase();
        this.propertyMappings.put(nameLC, new PropertyMapping(name, internalName, validatorName, datastore, managerOverrideable));
        String string = storedName = internalName != null ? internalName.toLowerCase() : nameLC;
        if (!this.defaultProperties.containsKey(storedName)) {
            Object propValue = System.getProperty(name);
            if (propValue == null) {
                propValue = value;
            }
            if (propValue != null) {
                if (validatorName != null) {
                    propValue = this.getValueForPropertyWithValidator(value, validatorName);
                }
                this.defaultProperties.put(storedName, propValue);
                this.defaultFrequentProperties.setProperty(storedName, propValue);
            }
        }
    }

    protected Object getValueForPropertyWithValidator(String value, String validatorName) {
        if (validatorName.equals(BooleanPropertyValidator.class.getName())) {
            return Boolean.valueOf(value);
        }
        if (validatorName.equals(IntegerPropertyValidator.class.getName())) {
            return Integer.valueOf(value);
        }
        return value;
    }

    @Override
    public boolean hasProperty(String name) {
        if (this.properties.containsKey(name)) {
            return true;
        }
        return this.defaultProperties.containsKey(name);
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties.containsKey(name)) {
            return super.getProperty(name);
        }
        return this.defaultProperties.get(name);
    }

    public synchronized void setPropertiesUsingFile(String filename) {
        if (filename == null) {
            return;
        }
        HashMap<String, Object> props = null;
        try {
            Properties propsFromFile = Configuration.getPropertiesFromPropertiesFile(filename);
            props = new HashMap<String, Object>();
            for (String key : propsFromFile.stringPropertyNames()) {
                props.put(key, propsFromFile.getProperty(key));
            }
            this.setPropertyInternal(PropertyNames.PROPERTY_PROPERTIES_FILE, filename);
        }
        catch (NucleusUserException nue) {
            this.properties.remove(PropertyNames.PROPERTY_PROPERTIES_FILE);
            throw nue;
        }
        if (props != null && !props.isEmpty()) {
            this.setPersistenceProperties(props);
        }
    }

    public Map<String, Object> getPersistencePropertiesDefaults() {
        return Collections.unmodifiableMap(this.defaultProperties);
    }

    public Map<String, Object> getPersistenceProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Set<String> getPropertyNamesWithPrefix(String prefix) {
        HashSet<String> propNames = null;
        for (String name : this.properties.keySet()) {
            if (!name.startsWith(prefix)) continue;
            if (propNames == null) {
                propNames = new HashSet<String>();
            }
            propNames.add(name);
        }
        return propNames;
    }

    public void setPersistenceProperties(Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public void setProperty(String name, Object value) {
        if (name != null) {
            String propertyName = name.trim();
            PropertyMapping mapping = this.propertyMappings.get(propertyName.toLowerCase());
            if (mapping != null) {
                if (mapping.validatorName != null) {
                    this.validatePropertyValue(mapping.internalName != null ? mapping.internalName.toLowerCase() : propertyName.toLowerCase(), value, mapping.validatorName);
                    if (value != null && value instanceof String) {
                        value = this.getValueForPropertyWithValidator((String)value, mapping.validatorName);
                    }
                }
                this.setPropertyInternal(mapping.internalName != null ? mapping.internalName : mapping.name, value);
                if (propertyName.equals(PropertyNames.PROPERTY_PROPERTIES_FILE)) {
                    this.setPropertiesUsingFile((String)value);
                }
            } else {
                this.setPropertyInternal(propertyName, value);
                if (!this.propertyMappings.isEmpty()) {
                    NucleusLogger.PERSISTENCE.info(Localiser.msg("008015", propertyName));
                }
            }
        }
    }

    public void validatePropertyValue(String name, Object value) {
        String validatorName = null;
        PropertyMapping mapping = this.propertyMappings.get(name.toLowerCase());
        if (mapping != null && (validatorName = mapping.validatorName) != null) {
            this.validatePropertyValue(name.toLowerCase(), value, validatorName);
        }
    }

    private void validatePropertyValue(String name, Object value, String validatorName) {
        if (validatorName == null) {
            return;
        }
        PropertyValidator validator = this.propertyValidators.get(validatorName);
        if (validator == null) {
            try {
                validator = (PropertyValidator)this.nucCtx.getPluginManager().createExecutableExtension("org.datanucleus.persistence_properties", "name", name, "validator", null, null);
                if (validator == null) {
                    Class validatorCls = this.nucCtx.getClassLoaderResolver(this.getClass().getClassLoader()).classForName(validatorName);
                    validator = (PropertyValidator)validatorCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if (validator != null) {
                    this.propertyValidators.put(validatorName, validator);
                }
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.warn("Error creating validator of type " + validatorName, e);
            }
        }
        if (validator != null && !validator.validate(name, value)) {
            throw new IllegalArgumentException(Localiser.msg("008012", name, value));
        }
    }

    public synchronized boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Configuration)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Configuration config = (Configuration)obj;
        if (this.properties == null ? config.properties != null : !this.properties.equals(config.properties)) {
            return false;
        }
        return !(this.defaultProperties == null ? config.defaultProperties != null : !this.defaultProperties.equals(config.defaultProperties));
    }

    public int hashCode() {
        return (this.properties != null ? this.properties.hashCode() : 0) ^ (this.defaultProperties != null ? this.defaultProperties.hashCode() : 0);
    }

    public static synchronized Properties getPropertiesFromPropertiesFile(String filename) {
        if (filename == null) {
            return null;
        }
        Properties props = new Properties();
        File file = new File(filename);
        if (file.exists()) {
            try {
                FileInputStream is = new FileInputStream(file);
                props.load(is);
                ((InputStream)is).close();
            }
            catch (FileNotFoundException e) {
                throw new NucleusUserException(Localiser.msg("008014", filename), e).setFatal();
            }
            catch (IOException e) {
                throw new NucleusUserException(Localiser.msg("008014", filename), e).setFatal();
            }
        }
        try {
            InputStream is = Configuration.class.getClassLoader().getResourceAsStream(filename);
            props.load(is);
            is.close();
        }
        catch (Exception e) {
            throw new NucleusUserException(Localiser.msg("008014", filename), e).setFatal();
        }
        return props;
    }

    static class PropertyMapping
    implements Serializable {
        private static final long serialVersionUID = 9004376979051886506L;
        String name;
        String internalName;
        String validatorName;
        boolean datastore;
        boolean managerOverride;

        public PropertyMapping(String name, String intName, String validator, boolean datastore, boolean managerOverride) {
            this.name = name;
            this.internalName = intName;
            this.validatorName = validator;
            this.datastore = datastore;
            this.managerOverride = managerOverride;
        }
    }
}

