/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.util.ConcurrentReferenceHashMap;
import org.datanucleus.util.Localiser;

public class ClassLoaderResolverImpl
implements ClassLoaderResolver {
    protected final ClassLoader contextLoader;
    protected int contextLoaderHashCode = 0;
    protected ClassLoader runtimeLoader;
    protected int runtimeLoaderHashCode = 0;
    protected ClassLoader userRegisteredLoader;
    protected int userRegisteredLoaderHashCode = 0;
    protected Map<String, Class> jreClasses = new ConcurrentHashMap<String, Class>();
    protected Map<String, Class> loadedClasses = new ConcurrentReferenceHashMap<String, Class>();
    protected Map<String, Class> unloadedClasses = new ConcurrentReferenceHashMap<String, Class>();
    protected Map<String, URL> resources = new ConcurrentReferenceHashMap<String, URL>();
    ThreadLocal primary = new ThreadLocal();

    public ClassLoaderResolverImpl(ClassLoader ctxLoader) {
        this.contextLoader = ctxLoader;
        if (this.contextLoader != null) {
            this.contextLoaderHashCode = this.contextLoader.hashCode();
        }
        this.loadJreClasses();
    }

    public ClassLoaderResolverImpl() {
        this.contextLoader = null;
        this.loadJreClasses();
    }

    protected void loadJreClasses() {
        this.jreClasses.put(ClassNameConstants.BOOLEAN, ClassConstants.BOOLEAN);
        this.jreClasses.put(ClassNameConstants.BYTE, ClassConstants.BYTE);
        this.jreClasses.put(ClassNameConstants.CHAR, ClassConstants.CHAR);
        this.jreClasses.put(ClassNameConstants.DOUBLE, ClassConstants.DOUBLE);
        this.jreClasses.put(ClassNameConstants.FLOAT, ClassConstants.FLOAT);
        this.jreClasses.put(ClassNameConstants.INT, ClassConstants.INT);
        this.jreClasses.put(ClassNameConstants.LONG, ClassConstants.LONG);
        this.jreClasses.put(ClassNameConstants.SHORT, ClassConstants.SHORT);
        this.jreClasses.put(ClassNameConstants.JAVA_LANG_BOOLEAN, ClassConstants.JAVA_LANG_BOOLEAN);
        this.jreClasses.put(ClassNameConstants.JAVA_LANG_BYTE, ClassConstants.JAVA_LANG_BYTE);
        this.jreClasses.put(ClassNameConstants.JAVA_LANG_CHARACTER, ClassConstants.JAVA_LANG_CHARACTER);
        this.jreClasses.put(ClassNameConstants.JAVA_LANG_DOUBLE, ClassConstants.JAVA_LANG_DOUBLE);
        this.jreClasses.put(ClassNameConstants.JAVA_LANG_FLOAT, ClassConstants.JAVA_LANG_FLOAT);
        this.jreClasses.put(ClassNameConstants.JAVA_LANG_INTEGER, ClassConstants.JAVA_LANG_INTEGER);
        this.jreClasses.put(ClassNameConstants.JAVA_LANG_LONG, ClassConstants.JAVA_LANG_LONG);
        this.jreClasses.put(ClassNameConstants.JAVA_LANG_SHORT, ClassConstants.JAVA_LANG_SHORT);
        this.jreClasses.put(ClassNameConstants.JAVA_LANG_STRING, ClassConstants.JAVA_LANG_STRING);
        this.jreClasses.put(ClassNameConstants.JAVA_MATH_BIGDECIMAL, ClassConstants.JAVA_MATH_BIGDECIMAL);
        this.jreClasses.put(ClassNameConstants.JAVA_MATH_BIGINTEGER, ClassConstants.JAVA_MATH_BIGINTEGER);
        this.jreClasses.put(ClassNameConstants.JAVA_UTIL_DATE, ClassConstants.JAVA_UTIL_DATE);
        this.jreClasses.put(ClassNameConstants.JAVA_SQL_DATE, ClassConstants.JAVA_SQL_DATE);
        this.jreClasses.put(ClassNameConstants.JAVA_SQL_TIME, ClassConstants.JAVA_SQL_TIME);
        this.jreClasses.put(ClassNameConstants.JAVA_SQL_TIMESTAMP, ClassConstants.JAVA_SQL_TIMESTAMP);
        this.jreClasses.put(ClassNameConstants.JAVA_TIME_LOCALDATE, ClassConstants.JAVA_TIME_LOCALDATE);
        this.jreClasses.put(ClassNameConstants.JAVA_TIME_LOCALTIME, ClassConstants.JAVA_TIME_LOCALTIME);
        this.jreClasses.put(ClassNameConstants.JAVA_TIME_LOCALDATETIME, ClassConstants.JAVA_TIME_LOCALDATETIME);
        this.jreClasses.put(ClassNameConstants.JAVA_IO_SERIALIZABLE, ClassConstants.JAVA_IO_SERIALIZABLE);
    }

    @Override
    public Class classForName(String name, ClassLoader primary) {
        if (name == null) {
            String msg = Localiser.msg("001000");
            throw new ClassNotResolvedException(msg);
        }
        Class cls = this.jreClasses.get(name);
        if (cls != null) {
            return cls;
        }
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        String cacheKey = this.newCacheKey(name, primary, threadClassLoader);
        cls = this.loadedClasses.get(cacheKey);
        if (cls != null) {
            return cls;
        }
        cls = this.unloadedClasses.get(cacheKey);
        if (cls != null) {
            return cls;
        }
        cls = this.classOrNull(name, primary);
        if (cls == null && this.primary.get() != null) {
            cls = this.classOrNull(name, (ClassLoader)this.primary.get());
        }
        if (cls == null) {
            cls = this.classOrNull(name, threadClassLoader);
        }
        if (cls == null) {
            cls = this.classOrNull(name, this.contextLoader);
        }
        if (cls == null && this.runtimeLoader != null) {
            cls = this.classOrNull(name, this.runtimeLoader);
        }
        if (cls == null && this.userRegisteredLoader != null) {
            cls = this.classOrNull(name, this.userRegisteredLoader);
        }
        if (cls == null) {
            throw new ClassNotResolvedException(Localiser.msg("001000", name));
        }
        this.unloadedClasses.put(cacheKey, cls);
        return cls;
    }

    private Class classForNameWithInitialize(String name, ClassLoader primary) {
        if (name == null) {
            throw new ClassNotResolvedException(Localiser.msg("001000"));
        }
        Class cls = this.jreClasses.get(name);
        if (cls != null) {
            return cls;
        }
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        String cacheKey = this.newCacheKey(name, primary, threadClassLoader);
        cls = this.loadedClasses.get(cacheKey);
        if (cls != null) {
            return cls;
        }
        cls = this.ClassOrNullWithInitialize(name, primary);
        if (cls == null && this.primary.get() != null) {
            cls = this.ClassOrNullWithInitialize(name, (ClassLoader)this.primary.get());
        }
        if (cls == null) {
            cls = this.ClassOrNullWithInitialize(name, threadClassLoader);
        }
        if (cls == null) {
            cls = this.ClassOrNullWithInitialize(name, this.contextLoader);
        }
        if (cls == null && this.runtimeLoader != null) {
            cls = this.ClassOrNullWithInitialize(name, this.runtimeLoader);
        }
        if (cls == null && this.userRegisteredLoader != null) {
            cls = this.ClassOrNullWithInitialize(name, this.userRegisteredLoader);
        }
        if (cls == null) {
            throw new ClassNotResolvedException(Localiser.msg("001000", name));
        }
        this.loadedClasses.put(cacheKey, cls);
        return cls;
    }

    private String newCacheKey(String prefix, ClassLoader primary, ClassLoader contextClassLoader) {
        int h = 3;
        if (primary != null) {
            h ^= primary.hashCode();
        }
        if (contextClassLoader != null) {
            h ^= contextClassLoader.hashCode();
        }
        h ^= this.contextLoaderHashCode;
        h ^= this.runtimeLoaderHashCode;
        return prefix + (h ^= this.userRegisteredLoaderHashCode);
    }

    @Override
    public Class classForName(String name, ClassLoader primary, boolean initialize) {
        if (initialize) {
            return this.classForNameWithInitialize(name, primary);
        }
        return this.classForName(name, primary);
    }

    @Override
    public Class classForName(String name) {
        return this.classForName(name, null);
    }

    @Override
    public Class classForName(String name, boolean initialize) {
        return this.classForName(name, null, initialize);
    }

    @Override
    public boolean isAssignableFrom(String class_name_1, String class_name_2) {
        if (class_name_1 == null || class_name_2 == null) {
            return false;
        }
        if (class_name_1.equals(class_name_2)) {
            return true;
        }
        Class class_1 = this.classForName(class_name_1);
        Class class_2 = this.classForName(class_name_2);
        return class_1.isAssignableFrom(class_2);
    }

    @Override
    public boolean isAssignableFrom(String class_name_1, Class class_2) {
        if (class_name_1 == null || class_2 == null) {
            return false;
        }
        if (class_name_1.equals(class_2.getName())) {
            return true;
        }
        try {
            Class class_1 = this.classForName(class_name_1, class_2.getClassLoader());
            return class_1.isAssignableFrom(class_2);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isAssignableFrom(Class class_1, String class_name_2) {
        if (class_1 == null || class_name_2 == null) {
            return false;
        }
        if (class_1.getName().equals(class_name_2)) {
            return true;
        }
        try {
            Class class_2 = this.classForName(class_name_2, class_1.getClassLoader());
            return class_1.isAssignableFrom(class_2);
        }
        catch (Exception e) {
            return false;
        }
    }

    private Class classOrNull(String name, ClassLoader loader) {
        try {
            return loader == null ? null : Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    private Class ClassOrNullWithInitialize(String name, ClassLoader loader) {
        try {
            return loader == null ? null : Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            return null;
        }
    }

    @Override
    public void setRuntimeClassLoader(ClassLoader loader) {
        this.runtimeLoader = loader;
        this.runtimeLoaderHashCode = this.runtimeLoader == null ? 0 : loader.hashCode();
    }

    @Override
    public void registerUserClassLoader(ClassLoader loader) {
        this.userRegisteredLoader = loader;
        this.userRegisteredLoaderHashCode = this.userRegisteredLoader == null ? 0 : loader.hashCode();
    }

    public Enumeration getResources(final String resourceName, final ClassLoader primary) throws IOException {
        final ArrayList list = new ArrayList();
        final ClassLoader userClassLoader = (ClassLoader)this.primary.get();
        final ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Enumeration<URL> loaderResourceEnum;
                    Enumeration<URL> primaryResourceEnum;
                    String name = resourceName;
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    if (primary != null) {
                        primaryResourceEnum = primary.getResources(name);
                        while (primaryResourceEnum.hasMoreElements()) {
                            list.add(primaryResourceEnum.nextElement());
                        }
                    }
                    if (userClassLoader != null) {
                        primaryResourceEnum = userClassLoader.getResources(name);
                        while (primaryResourceEnum.hasMoreElements()) {
                            list.add(primaryResourceEnum.nextElement());
                        }
                    }
                    if (threadClassLoader != null) {
                        Enumeration<URL> resourceEnum = threadClassLoader.getResources(name);
                        while (resourceEnum.hasMoreElements()) {
                            list.add(resourceEnum.nextElement());
                        }
                    }
                    if (ClassLoaderResolverImpl.this.contextLoader != null) {
                        Enumeration<URL> pmResourceEnum = ClassLoaderResolverImpl.this.contextLoader.getResources(name);
                        while (pmResourceEnum.hasMoreElements()) {
                            list.add(pmResourceEnum.nextElement());
                        }
                    }
                    if (ClassLoaderResolverImpl.this.runtimeLoader != null) {
                        loaderResourceEnum = ClassLoaderResolverImpl.this.runtimeLoader.getResources(name);
                        while (loaderResourceEnum.hasMoreElements()) {
                            list.add(loaderResourceEnum.nextElement());
                        }
                    }
                    if (ClassLoaderResolverImpl.this.userRegisteredLoader != null) {
                        loaderResourceEnum = ClassLoaderResolverImpl.this.userRegisteredLoader.getResources(name);
                        while (loaderResourceEnum.hasMoreElements()) {
                            list.add(loaderResourceEnum.nextElement());
                        }
                    }
                }
                catch (IOException ex) {
                    throw new NucleusException(ex.getMessage(), ex);
                }
                return null;
            }
        });
        return Collections.enumeration(new LinkedHashSet(list));
    }

    @Override
    public URL getResource(final String resourceName, final ClassLoader primary) {
        final ClassLoader userClassLoader = (ClassLoader)this.primary.get();
        URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String resName = resourceName;
                URL url = ClassLoaderResolverImpl.this.resources.get(resName);
                if (url != null) {
                    return url;
                }
                if (resName.startsWith("/")) {
                    resName = resName.substring(1);
                }
                if (primary != null && (url = primary.getResource(resName)) != null) {
                    ClassLoaderResolverImpl.this.resources.put(resName, url);
                    return url;
                }
                if (userClassLoader != null && (url = userClassLoader.getResource(resName)) != null) {
                    ClassLoaderResolverImpl.this.resources.put(resName, url);
                    return url;
                }
                ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                if (threadClassLoader != null && (url = threadClassLoader.getResource(resName)) != null) {
                    ClassLoaderResolverImpl.this.resources.put(resName, url);
                    return url;
                }
                if (ClassLoaderResolverImpl.this.contextLoader != null && (url = ClassLoaderResolverImpl.this.contextLoader.getResource(resName)) != null) {
                    ClassLoaderResolverImpl.this.resources.put(resName, url);
                    return url;
                }
                if (ClassLoaderResolverImpl.this.runtimeLoader != null && (url = ClassLoaderResolverImpl.this.runtimeLoader.getResource(resName)) != null) {
                    ClassLoaderResolverImpl.this.resources.put(resName, url);
                    return url;
                }
                if (ClassLoaderResolverImpl.this.userRegisteredLoader != null && (url = ClassLoaderResolverImpl.this.userRegisteredLoader.getResource(resName)) != null) {
                    ClassLoaderResolverImpl.this.resources.put(resName, url);
                    return url;
                }
                return null;
            }
        });
        return url;
    }

    @Override
    public void setPrimary(ClassLoader primary) {
        this.primary.set(primary);
    }

    @Override
    public void unsetPrimary() {
        this.primary.set(null);
    }

    public String toString() {
        return "ClassLoaderResolver: primary=" + this.primary + " contextLoader=" + this.contextLoader + " runtimeLoader=" + this.runtimeLoader + " registeredLoader=" + this.userRegisteredLoader;
    }
}

