/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.hive.org.apache.commons.lang.StringUtils;
import org.jsonschema2pojo.URLProtocol;

public class URLUtil {
    public static URLProtocol parseProtocol(String input) {
        return URLProtocol.fromString(StringUtils.substringBefore(input, ":"));
    }

    public static URL parseURL(String input) {
        try {
            switch (URLUtil.parseProtocol(input)) {
                case NO_PROTOCOL: {
                    return new File(input).toURI().toURL();
                }
            }
            return URI.create(input).toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Unable to parse source: %s", input), e);
        }
    }

    public static File getFileFromURL(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("URL contains an invalid URI syntax: %s", url), e);
        }
    }
}

