/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveServer2TransportMode;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.com.google.common.collect.ImmutableSet;
import org.apache.hive.org.apache.commons.lang3.EnumUtils;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.apache.hive.service.auth.HiveAuthConstants;

public class AuthType {
    static final Set<HiveAuthConstants.AuthTypes> PASSWORD_BASED_TYPES = ImmutableSet.of(HiveAuthConstants.AuthTypes.LDAP, HiveAuthConstants.AuthTypes.CUSTOM, HiveAuthConstants.AuthTypes.PAM, HiveAuthConstants.AuthTypes.NONE);
    private final BitSet typeBits;
    private final List<HiveAuthConstants.AuthTypes> authTypes = new ArrayList<HiveAuthConstants.AuthTypes>();
    private final HiveServer2TransportMode mode;

    @VisibleForTesting
    public AuthType(String authTypes, HiveServer2TransportMode mode) {
        this.mode = mode;
        this.typeBits = new BitSet();
        this.parseTypes(authTypes);
        this.verifyTypes(authTypes);
    }

    private void parseTypes(String authTypes) {
        String[] types;
        for (String type : types = authTypes.split(",")) {
            if (!EnumUtils.isValidEnumIgnoreCase(HiveAuthConstants.AuthTypes.class, type)) {
                throw new IllegalArgumentException(type + " is not a valid authentication type.");
            }
            HiveAuthConstants.AuthTypes authType = EnumUtils.getEnumIgnoreCase(HiveAuthConstants.AuthTypes.class, type);
            this.authTypes.add(authType);
            this.typeBits.set(authType.ordinal());
        }
    }

    private void verifyTypes(String authTypes) {
        if (this.typeBits.cardinality() == 1) {
            return;
        }
        if (this.typeBits.get(HiveAuthConstants.AuthTypes.NOSASL.ordinal())) {
            throw new UnsupportedOperationException("NOSASL can't be along with other auth methods: " + authTypes);
        }
        if (this.typeBits.get(HiveAuthConstants.AuthTypes.NONE.ordinal())) {
            throw new UnsupportedOperationException("None can't be along with other auth methods: " + authTypes);
        }
        if (this.areAnyEnabled(PASSWORD_BASED_TYPES) && !this.isExactlyOneEnabled(PASSWORD_BASED_TYPES)) {
            throw new RuntimeException("Multiple password based auth methods found: " + authTypes);
        }
        if ((this.typeBits.get(HiveAuthConstants.AuthTypes.SAML.ordinal()) || this.typeBits.get(HiveAuthConstants.AuthTypes.JWT.ordinal())) && (this.mode == HiveServer2TransportMode.all || this.mode == HiveServer2TransportMode.binary)) {
            throw new UnsupportedOperationException("HiveServer2 binary mode doesn't support JWT and SAML, please consider using http mode only");
        }
    }

    private boolean isExactlyOneEnabled(Collection<HiveAuthConstants.AuthTypes> types) {
        boolean areAnyEnabled = false;
        boolean areTwoEnabled = false;
        Iterator<HiveAuthConstants.AuthTypes> it = types.iterator();
        while (!areTwoEnabled && it.hasNext()) {
            boolean isCurrentTypeEnabled = this.isEnabled(it.next());
            areTwoEnabled = areAnyEnabled && isCurrentTypeEnabled;
            areAnyEnabled |= isCurrentTypeEnabled;
        }
        return areAnyEnabled && !areTwoEnabled;
    }

    private boolean areAnyEnabled(Collection<HiveAuthConstants.AuthTypes> types) {
        boolean areAnyEnabled = false;
        Iterator<HiveAuthConstants.AuthTypes> it = types.iterator();
        while (!areAnyEnabled && it.hasNext()) {
            areAnyEnabled = this.isEnabled(it.next());
        }
        return areAnyEnabled;
    }

    public boolean isEnabled(HiveAuthConstants.AuthTypes type) {
        return this.typeBits.get(type.ordinal());
    }

    public boolean isPasswordBasedAuthEnabled() {
        return this.areAnyEnabled(PASSWORD_BASED_TYPES);
    }

    public String getAuthTypes() {
        return this.authTypes.stream().map(au -> au.getAuthName()).collect(Collectors.joining(","));
    }

    public String getPasswordBasedAuthStr() {
        if (this.isEnabled(HiveAuthConstants.AuthTypes.NOSASL)) {
            return HiveAuthConstants.AuthTypes.NOSASL.getAuthName();
        }
        for (HiveAuthConstants.AuthTypes type : PASSWORD_BASED_TYPES) {
            if (!this.isEnabled(type)) continue;
            return type.getAuthName();
        }
        return "";
    }

    public boolean isPasswordBasedAuth(HiveAuthConstants.AuthTypes type) {
        return PASSWORD_BASED_TYPES.contains((Object)type);
    }

    public static boolean isKerberosAuthMode(Configuration conf) {
        AuthType authType = AuthType.authTypeFromConf(conf, true);
        return authType.isEnabled(HiveAuthConstants.AuthTypes.KERBEROS);
    }

    public static boolean isSamlAuthMode(Configuration conf) {
        AuthType authType = AuthType.authTypeFromConf(conf, true);
        return authType.isEnabled(HiveAuthConstants.AuthTypes.SAML);
    }

    public static AuthType authTypeFromConf(Configuration conf, boolean isHttpMode) {
        HiveServer2TransportMode transportMode;
        String authTypeStr = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
        boolean isAuthTypeEmpty = StringUtils.isEmpty(authTypeStr);
        if (isHttpMode) {
            transportMode = HiveServer2TransportMode.http;
            if (isAuthTypeEmpty) {
                authTypeStr = HiveAuthConstants.AuthTypes.NOSASL.getAuthName();
            }
        } else {
            transportMode = HiveServer2TransportMode.binary;
            if (isAuthTypeEmpty) {
                authTypeStr = HiveAuthConstants.AuthTypes.NONE.getAuthName();
            }
        }
        return new AuthType(authTypeStr, transportMode);
    }
}

