/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.server.quorum;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.org.apache.zookeeper.common.Time;
import org.apache.hive.org.apache.zookeeper.server.ObserverBean;
import org.apache.hive.org.apache.zookeeper.server.Request;
import org.apache.hive.org.apache.zookeeper.server.ServerMetrics;
import org.apache.hive.org.apache.zookeeper.server.TxnLogEntry;
import org.apache.hive.org.apache.zookeeper.server.quorum.Learner;
import org.apache.hive.org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.hive.org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import org.apache.hive.org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.hive.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.hive.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.hive.org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.hive.org.apache.zookeeper.txn.SetDataTxn;
import org.apache.hive.org.apache.zookeeper.txn.TxnDigest;
import org.apache.hive.org.apache.zookeeper.txn.TxnHeader;
import org.apache.jute.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Observer
extends Learner {
    private static final Logger LOG = LoggerFactory.getLogger(Observer.class);
    public static final String OBSERVER_RECONNECT_DELAY_MS = "zookeeper.observer.reconnectDelayMs";
    public static final String OBSERVER_ELECTION_DELAY_MS = "zookeeper.observer.election.DelayMs";
    private static final long reconnectDelayMs = Long.getLong("zookeeper.observer.reconnectDelayMs", 0L);
    private static volatile long observerElectionDelayMs;
    private static final AtomicReference<QuorumPeer.QuorumServer> nextLearnerMaster;
    private QuorumPeer.QuorumServer currentLearnerMaster = null;

    Observer(QuorumPeer self, ObserverZooKeeperServer observerZooKeeperServer) {
        this.self = self;
        this.zk = observerZooKeeperServer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Observer ").append(this.sock);
        sb.append(" pendingRevalidationCount:").append(this.pendingRevalidations.size());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void observeLeader() throws Exception {
        this.zk.registerJMX(new ObserverBean(this, this.zk), this.self.jmxLocalPeerBean);
        long connectTime = 0L;
        boolean completedSync = false;
        try {
            this.self.setZabState(QuorumPeer.ZabState.DISCOVERY);
            QuorumPeer.QuorumServer master = this.findLearnerMaster();
            try {
                this.connectToLeader(master.addr, master.hostname);
                connectTime = System.currentTimeMillis();
                long newLeaderZxid = this.registerWithLeader(16);
                if (this.self.isReconfigStateChange()) {
                    throw new Exception("learned about role change");
                }
                long startTime = Time.currentElapsedTime();
                this.self.setLeaderAddressAndId(master.addr, master.getId());
                this.self.setZabState(QuorumPeer.ZabState.SYNCHRONIZATION);
                this.syncWithLeader(newLeaderZxid);
                this.self.setZabState(QuorumPeer.ZabState.BROADCAST);
                completedSync = true;
                long syncTime = Time.currentElapsedTime() - startTime;
                ServerMetrics.getMetrics().OBSERVER_SYNC_TIME.add(syncTime);
                QuorumPacket qp = new QuorumPacket();
                while (this.isRunning() && nextLearnerMaster.get() == null) {
                    this.readPacket(qp);
                    this.processPacket(qp);
                }
            }
            catch (Exception e) {
                LOG.warn("Exception when observing the leader", e);
                this.closeSocket();
                this.pendingRevalidations.clear();
            }
            this.currentLearnerMaster = null;
            this.zk.unregisterJMX(this);
            if (connectTime == 0L) return;
        }
        catch (Throwable throwable) {
            this.currentLearnerMaster = null;
            this.zk.unregisterJMX(this);
            if (connectTime == 0L) throw throwable;
            long connectionDuration = System.currentTimeMillis() - connectTime;
            LOG.info("Disconnected from leader (with address: {}). Was connected for {}ms. Sync state: {}", this.leaderAddr, connectionDuration, completedSync);
            this.messageTracker.dumpToLog(this.leaderAddr.toString());
            throw throwable;
        }
        long connectionDuration = System.currentTimeMillis() - connectTime;
        LOG.info("Disconnected from leader (with address: {}). Was connected for {}ms. Sync state: {}", this.leaderAddr, connectionDuration, completedSync);
        this.messageTracker.dumpToLog(this.leaderAddr.toString());
    }

    private QuorumPeer.QuorumServer findLearnerMaster() {
        QuorumPeer.QuorumServer master;
        QuorumPeer.QuorumServer prescribedLearnerMaster = nextLearnerMaster.getAndSet(null);
        if (prescribedLearnerMaster != null && this.self.validateLearnerMaster(Long.toString(prescribedLearnerMaster.id)) == null) {
            LOG.warn("requested next learner master {} is no longer valid", (Object)prescribedLearnerMaster);
            prescribedLearnerMaster = null;
        }
        this.currentLearnerMaster = master = prescribedLearnerMaster == null ? this.self.findLearnerMaster(this.findLeader()) : prescribedLearnerMaster;
        if (master == null) {
            LOG.warn("No learner master found");
        } else {
            LOG.info("Observing new leader sid={} addr={}", (Object)master.id, (Object)master.addr);
        }
        return master;
    }

    protected void processPacket(QuorumPacket qp) throws Exception {
        switch (qp.getType()) {
            case 5: {
                this.ping(qp);
                break;
            }
            case 2: {
                LOG.warn("Ignoring proposal");
                break;
            }
            case 4: {
                LOG.warn("Ignoring commit");
                break;
            }
            case 12: {
                LOG.error("Received an UPTODATE message after Observer started");
                break;
            }
            case 6: {
                this.revalidate(qp);
                break;
            }
            case 7: {
                ((ObserverZooKeeperServer)this.zk).sync();
                break;
            }
            case 8: {
                ServerMetrics.getMetrics().LEARNER_COMMIT_RECEIVED_COUNT.add(1L);
                TxnLogEntry logEntry = SerializeUtils.deserializeTxn(qp.getData());
                TxnHeader hdr = logEntry.getHeader();
                Record txn = logEntry.getTxn();
                TxnDigest digest = logEntry.getDigest();
                Request request = new Request(hdr.getClientId(), hdr.getCxid(), hdr.getType(), hdr, txn, 0L);
                request.logLatency(ServerMetrics.getMetrics().COMMIT_PROPAGATION_LATENCY);
                request.setTxnDigest(digest);
                ObserverZooKeeperServer obs = (ObserverZooKeeperServer)this.zk;
                obs.commitRequest(request);
                break;
            }
            case 19: {
                ByteBuffer buffer = ByteBuffer.wrap(qp.getData());
                long suggestedLeaderId = buffer.getLong();
                byte[] remainingdata = new byte[buffer.remaining()];
                buffer.get(remainingdata);
                TxnLogEntry logEntry = SerializeUtils.deserializeTxn(remainingdata);
                TxnHeader hdr = logEntry.getHeader();
                Record txn = logEntry.getTxn();
                TxnDigest digest = logEntry.getDigest();
                QuorumVerifier qv = this.self.configFromString(new String(((SetDataTxn)txn).getData(), StandardCharsets.UTF_8));
                Request request = new Request(hdr.getClientId(), hdr.getCxid(), hdr.getType(), hdr, txn, 0L);
                request.setTxnDigest(digest);
                ObserverZooKeeperServer obs = (ObserverZooKeeperServer)this.zk;
                boolean majorChange = this.self.processReconfig(qv, suggestedLeaderId, qp.getZxid(), true);
                obs.commitRequest(request);
                if (!majorChange) break;
                throw new Exception("changes proposed in reconfig");
            }
            default: {
                LOG.warn("Unknown packet type: {}", (Object)LearnerHandler.packetToString(qp));
            }
        }
    }

    @Override
    public void shutdown() {
        LOG.info("shutdown Observer");
        super.shutdown();
    }

    static void waitForReconnectDelay() {
        Observer.waitForReconnectDelayHelper(reconnectDelayMs);
    }

    static void waitForObserverElectionDelay() {
        Observer.waitForReconnectDelayHelper(observerElectionDelayMs);
    }

    private static void waitForReconnectDelayHelper(long delayValueMs) {
        if (delayValueMs > 0L) {
            long randomDelay = ThreadLocalRandom.current().nextLong(delayValueMs);
            LOG.info("Waiting for {} ms before reconnecting with the leader", (Object)randomDelay);
            try {
                Thread.sleep(randomDelay);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting", e);
            }
        }
    }

    public long getLearnerMasterId() {
        QuorumPeer.QuorumServer current = this.currentLearnerMaster;
        return current == null ? -1L : current.id;
    }

    public boolean setLearnerMaster(String learnerMaster) {
        QuorumPeer.QuorumServer server = this.self.validateLearnerMaster(learnerMaster);
        if (server == null) {
            return false;
        }
        if (server.equals(this.currentLearnerMaster)) {
            LOG.info("Already connected to requested learner master sid={} addr={}", (Object)server.id, (Object)server.addr);
            return true;
        }
        LOG.info("Requesting disconnect and reconnect to new learner master sid={} addr={}", (Object)server.id, (Object)server.addr);
        nextLearnerMaster.set(server);
        return true;
    }

    public QuorumPeer.QuorumServer getCurrentLearnerMaster() {
        return this.currentLearnerMaster;
    }

    public static long getObserverElectionDelayMs() {
        return observerElectionDelayMs;
    }

    public static void setObserverElectionDelayMs(long electionDelayMs) {
        observerElectionDelayMs = electionDelayMs;
        LOG.info("{} = {}", (Object)OBSERVER_ELECTION_DELAY_MS, (Object)observerElectionDelayMs);
    }

    static {
        LOG.info("{} = {}", (Object)OBSERVER_RECONNECT_DELAY_MS, (Object)reconnectDelayMs);
        observerElectionDelayMs = Long.getLong(OBSERVER_ELECTION_DELAY_MS, 200L);
        LOG.info("{} = {}", (Object)OBSERVER_ELECTION_DELAY_MS, (Object)observerElectionDelayMs);
        nextLearnerMaster = new AtomicReference();
    }
}

