/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.thrift.transport;

import org.apache.hive.org.apache.thrift.TConfiguration;
import org.apache.hive.org.apache.thrift.transport.AutoExpandingBuffer;
import org.apache.hive.org.apache.thrift.transport.TEndpointTransport;
import org.apache.hive.org.apache.thrift.transport.TTransportException;

public final class AutoExpandingBufferWriteTransport
extends TEndpointTransport {
    private final AutoExpandingBuffer buf;
    private int pos;
    private int res;

    public AutoExpandingBufferWriteTransport(TConfiguration config, int initialCapacity, int frontReserve) throws TTransportException {
        super(config);
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("initialCapacity");
        }
        if (frontReserve < 0 || initialCapacity < frontReserve) {
            throw new IllegalArgumentException("frontReserve");
        }
        this.buf = new AutoExpandingBuffer(initialCapacity);
        this.pos = frontReserve;
        this.res = frontReserve;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() throws TTransportException {
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] toWrite, int off, int len) throws TTransportException {
        this.buf.resizeIfNecessary(this.pos + len);
        System.arraycopy(toWrite, off, this.buf.array(), this.pos, len);
        this.pos += len;
    }

    public AutoExpandingBuffer getBuf() {
        return this.buf;
    }

    public int getLength() {
        return this.pos;
    }

    public void reset() {
        this.pos = this.res;
    }
}

