/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.http;

import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cli.status.ExitCode;
import org.apache.hadoop.hive.llap.cli.status.LlapStatusServiceCommandLine;
import org.apache.hadoop.hive.llap.cli.status.LlapStatusServiceDriver;
import org.apache.hive.http.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(LlapServlet.class);

    public void init() throws ServletException {
    }

    private Configuration getConfFromContext() {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("hive.conf");
        assert (conf != null);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!HttpServer.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
                return;
            }
            String clusterName = HiveConf.getVar(this.getConfFromContext(), HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
            try (PrintWriter writer = null;){
                response.setContentType("application/json; charset=utf8");
                response.setHeader("Access-Control-Allow-Methods", "GET");
                response.setHeader("Access-Control-Allow-Origin", "*");
                response.setHeader("Cache-Control", "no-transform,public,max-age=60,s-maxage=60");
                writer = response.getWriter();
                if (clusterName != null) {
                    clusterName = clusterName.trim();
                }
                if (clusterName == null || clusterName.isEmpty()) {
                    writer.print("{\"LLAP\": \"No llap daemons configured. ");
                    writer.print("Check hive.llap.daemon.service.hosts.\"}");
                    return;
                }
                if (clusterName.startsWith("@")) {
                    clusterName = clusterName.substring(1);
                }
                LOG.info("Retrieving info for cluster: " + clusterName);
                LlapStatusServiceDriver driver = new LlapStatusServiceDriver();
                ExitCode ret = driver.run(LlapStatusServiceCommandLine.parseArguments((String[])new String[]{"-n", clusterName}), 0L);
                if (ret == ExitCode.SUCCESS) {
                    driver.outputJson(writer);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception while processing llap status request", e);
            response.setStatus(500);
        }
    }
}

