/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

public class ColumnType {
    private final String type;
    private final Precision precision;

    public static ColumnType parse(String type) {
        return new ColumnType(ColumnType.parseType(type), Precision.parse(type));
    }

    public ColumnType(String type, Precision precision) {
        this.type = type;
        this.precision = precision;
    }

    private static String parseType(String type) {
        int index = type.indexOf(40);
        return index == -1 ? type : type.substring(0, index);
    }

    public String typeString() {
        return this.type;
    }

    public Precision precision() {
        return this.precision;
    }

    private static class Precision {
        public final int len;
        public final int scale;

        public static Precision parse(String type) {
            int len;
            int open = type.indexOf(40);
            if (open == -1) {
                return new Precision(0, 0);
            }
            int scale = 0;
            int comma = type.indexOf(44, open);
            int close = type.indexOf(41, open);
            if (comma == -1) {
                len = Integer.parseInt(type.substring(open + 1, close));
            } else {
                len = Integer.parseInt(type.substring(open + 1, comma));
                scale = Integer.parseInt(type.substring(comma + 1, close));
            }
            return new Precision(scale, len);
        }

        Precision(int scale, int len) {
            this.len = len;
            this.scale = scale;
        }
    }
}

