/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;
import org.apache.hadoop.io.erasurecode.rawcoder.util.RSUtil;

@InterfaceAudience.Private
public final class HHUtil {
    private HHUtil() {
    }

    public static int[] initPiggyBackIndexWithoutPBVec(int numDataUnits, int numParityUnits) {
        int piggyBackSize = numDataUnits / (numParityUnits - 1);
        int[] piggyBackIndex = new int[numParityUnits];
        for (int i = 0; i < numDataUnits; ++i) {
            if (i % piggyBackSize != 0) continue;
            piggyBackIndex[i / piggyBackSize] = i;
        }
        piggyBackIndex[numParityUnits - 1] = numDataUnits;
        return piggyBackIndex;
    }

    public static int[] initPiggyBackFullIndexVec(int numDataUnits, int[] piggyBackIndex) {
        int[] piggyBackFullIndex = new int[numDataUnits];
        for (int i = 1; i < piggyBackIndex.length; ++i) {
            for (int j = piggyBackIndex[i - 1]; j < piggyBackIndex[i]; ++j) {
                piggyBackFullIndex[j] = i;
            }
        }
        return piggyBackFullIndex;
    }

    public static ByteBuffer[] getPiggyBacksFromInput(ByteBuffer[] inputs, int[] piggyBackIndex, int numParityUnits, int pgIndex, RawErasureEncoder encoder) throws IOException {
        ByteBuffer[] emptyInput = new ByteBuffer[inputs.length];
        ByteBuffer[] tempInput = new ByteBuffer[inputs.length];
        int[] inputPositions = new int[inputs.length];
        for (int m4 = 0; m4 < inputs.length; ++m4) {
            if (inputs[m4] == null) continue;
            emptyInput[m4] = HHUtil.allocateByteBuffer(inputs[m4].isDirect(), inputs[m4].remaining());
        }
        ByteBuffer[] tempOutput = new ByteBuffer[numParityUnits];
        for (int m5 = 0; m5 < numParityUnits; ++m5) {
            tempOutput[m5] = HHUtil.allocateByteBuffer(inputs[m5].isDirect(), inputs[0].remaining());
        }
        ByteBuffer[] piggyBacks = new ByteBuffer[numParityUnits - 1];
        assert (piggyBackIndex.length >= numParityUnits);
        for (int i = 0; i < numParityUnits - 1; ++i) {
            int j;
            for (int k = piggyBackIndex[i]; k < piggyBackIndex[i + 1]; ++k) {
                tempInput[k] = inputs[k];
                inputPositions[k] = inputs[k].position();
            }
            for (int n = 0; n < emptyInput.length; ++n) {
                if (tempInput[n] != null) continue;
                tempInput[n] = emptyInput[n];
                inputPositions[n] = emptyInput[n].position();
            }
            encoder.encode(tempInput, tempOutput);
            piggyBacks[i] = HHUtil.cloneBufferData(tempOutput[pgIndex]);
            for (j = 0; j < tempInput.length; ++j) {
                if (tempInput[j] == null) continue;
                tempInput[j].position(inputPositions[j]);
                tempInput[j] = null;
            }
            for (j = 0; j < tempOutput.length; ++j) {
                tempOutput[j].clear();
            }
        }
        return piggyBacks;
    }

    private static ByteBuffer cloneBufferData(ByteBuffer srcBuffer) {
        ByteBuffer destBuffer;
        byte[] bytesArr = new byte[srcBuffer.remaining()];
        srcBuffer.mark();
        srcBuffer.get(bytesArr);
        srcBuffer.reset();
        if (!srcBuffer.isDirect()) {
            destBuffer = ByteBuffer.wrap(bytesArr);
        } else {
            destBuffer = ByteBuffer.allocateDirect(srcBuffer.remaining());
            destBuffer.put(bytesArr);
            destBuffer.flip();
        }
        return destBuffer;
    }

    public static ByteBuffer allocateByteBuffer(boolean useDirectBuffer, int bufSize) {
        if (useDirectBuffer) {
            return ByteBuffer.allocateDirect(bufSize);
        }
        return ByteBuffer.allocate(bufSize);
    }

    public static ByteBuffer getPiggyBackForDecode(ByteBuffer[][] inputs, ByteBuffer[][] outputs, int pbParityIndex, int numDataUnits, int numParityUnits, int pbIndex) {
        ByteBuffer fisrtValidInput = HHUtil.findFirstValidInput(inputs[0]);
        int bufSize = fisrtValidInput.remaining();
        ByteBuffer piggybacks = HHUtil.allocateByteBuffer(fisrtValidInput.isDirect(), bufSize);
        if (pbParityIndex < numParityUnits) {
            int inputIdx = numDataUnits + pbParityIndex;
            int inputPos = inputs[1][inputIdx].position();
            int outputPos = outputs[1][pbParityIndex].position();
            int m4 = 0;
            int k = inputPos;
            int n = outputPos;
            while (m4 < bufSize) {
                int valueWithPb = 0xFF & inputs[1][inputIdx].get(k);
                int valueWithoutPb = 0xFF & outputs[1][pbParityIndex].get(n);
                piggybacks.put(m4, (byte)RSUtil.GF.add(valueWithPb, valueWithoutPb));
                ++k;
                ++m4;
                ++n;
            }
        } else {
            int sum = 0;
            for (int k = 0; k < bufSize; ++k) {
                sum = 0;
                for (int i = 1; i < numParityUnits; ++i) {
                    int inIdx = numDataUnits + i;
                    int inPos = inputs[1][numDataUnits + i].position();
                    int outPos = outputs[1][i].position();
                    sum = RSUtil.GF.add(sum, 0xFF & inputs[1][inIdx].get(inPos + k));
                    sum = RSUtil.GF.add(sum, 0xFF & outputs[1][i].get(outPos + k));
                }
                sum = RSUtil.GF.add(sum, 0xFF & inputs[0][numDataUnits + pbIndex].get(inputs[0][numDataUnits + pbIndex].position() + k));
                piggybacks.put(k, (byte)sum);
            }
        }
        return piggybacks;
    }

    public static <T> T findFirstValidInput(T[] inputs) {
        for (T input : inputs) {
            if (input == null) continue;
            return input;
        }
        throw new HadoopIllegalArgumentException("Invalid inputs are found, all being null");
    }
}

