/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.teradata;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hive.org.apache.commons.io.EndianUtils;
import org.apache.hive.org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.hive.org.apache.commons.lang3.ArrayUtils;

public class TeradataBinaryDataOutputStream
extends ByteArrayOutputStream {
    private static final int TIMESTAMP_NO_NANOS_BYTE_NUM = 19;

    public void writeVarChar(HiveVarcharWritable writable) throws IOException {
        if (writable == null) {
            EndianUtils.writeSwappedShort((OutputStream)((Object)this), (short)0);
            return;
        }
        Text t2 = writable.getTextValue();
        int varcharLength = t2.getLength();
        EndianUtils.writeSwappedShort((OutputStream)((Object)this), (short)((short)varcharLength));
        this.write(t2.getBytes(), 0, varcharLength);
    }

    public void writeInt(int i) throws IOException {
        EndianUtils.writeSwappedInteger((OutputStream)((Object)this), (int)i);
    }

    public void writeTimestamp(TimestampWritableV2 timestamp, int byteNum) throws IOException {
        if (timestamp == null) {
            String pad = String.join((CharSequence)"", Collections.nCopies(byteNum, " "));
            this.write(pad.getBytes("UTF8"));
            return;
        }
        String sTimeStamp = timestamp.getTimestamp().toString();
        if (sTimeStamp.length() >= byteNum) {
            this.write(sTimeStamp.substring(0, byteNum).getBytes("UTF8"));
            return;
        }
        this.write(sTimeStamp.getBytes("UTF8"));
        Object pad = sTimeStamp.length() == 19 ? "." + String.join((CharSequence)"", Collections.nCopies(byteNum - sTimeStamp.length() - 1, "0")) : String.join((CharSequence)"", Collections.nCopies(byteNum - sTimeStamp.length(), "0"));
        this.write(((String)pad).getBytes("UTF8"));
    }

    public void writeDouble(double d) throws IOException {
        EndianUtils.writeSwappedDouble((OutputStream)((Object)this), (double)d);
    }

    public void writeDate(DateWritableV2 date) throws IOException {
        if (date == null) {
            EndianUtils.writeSwappedInteger((OutputStream)((Object)this), (int)0);
            return;
        }
        int toWrite = date.get().getYear() * 10000 + date.get().getMonth() * 100 + date.get().getDay() - 19000000;
        EndianUtils.writeSwappedInteger((OutputStream)((Object)this), (int)toWrite);
    }

    public void writeLong(long l) throws IOException {
        EndianUtils.writeSwappedLong((OutputStream)((Object)this), (long)l);
    }

    public void writeChar(HiveCharWritable writable, int length) throws IOException {
        if (writable == null) {
            String pad = String.join((CharSequence)"", Collections.nCopies(length, " "));
            this.write(pad.getBytes("UTF8"));
            return;
        }
        Text t2 = writable.getStrippedValue();
        int contentLength = t2.getLength();
        this.write(t2.getBytes(), 0, contentLength);
        if (length - contentLength < 0) {
            throw new IOException(String.format("The byte num %s of HiveCharWritable is more than the byte num %s we can hold. The content of HiveCharWritable is %s", contentLength, length, writable.getPaddedValue()));
        }
        if (length > contentLength) {
            String pad = String.join((CharSequence)"", Collections.nCopies(length - contentLength, " "));
            this.write(pad.getBytes("UTF8"));
        }
    }

    public void writeDecimal(HiveDecimalWritable writable, int byteNum, int scale) throws IOException {
        if (writable == null) {
            byte[] pad = new byte[byteNum];
            this.write(pad);
            return;
        }
        int hiveScale = writable.getHiveDecimal().scale();
        BigInteger bigInteger = writable.getHiveDecimal().unscaledValue();
        if (hiveScale < scale) {
            BigInteger multiplicand = new BigInteger("1" + String.join((CharSequence)"", Collections.nCopies(scale - hiveScale, "0")));
            bigInteger = bigInteger.multiply(multiplicand);
        }
        byte[] content = bigInteger.toByteArray();
        int signBit = content[0] >> 7 & 1;
        ArrayUtils.reverse(content);
        this.write(content);
        if (byteNum > content.length) {
            byte[] pad;
            if (signBit == 0) {
                pad = new byte[byteNum - content.length];
            } else {
                pad = new byte[byteNum - content.length];
                Arrays.fill(pad, (byte)-1);
            }
            this.write(pad);
        }
    }

    public void writeShort(short s2) throws IOException {
        EndianUtils.writeSwappedShort((OutputStream)((Object)this), (short)s2);
    }

    public void writeVarByte(BytesWritable writable) throws IOException {
        if (writable == null) {
            EndianUtils.writeSwappedShort((OutputStream)((Object)this), (short)0);
            return;
        }
        int varbyteLength = writable.getLength();
        EndianUtils.writeSwappedShort((OutputStream)((Object)this), (short)((short)varbyteLength));
        this.write(writable.getBytes(), 0, varbyteLength);
    }
}

