/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveIntervalYearMonthObjectInspector;
import org.apache.hadoop.io.Text;

public class LazyHiveIntervalYearMonth
extends LazyPrimitive<LazyHiveIntervalYearMonthObjectInspector, HiveIntervalYearMonthWritable> {
    public LazyHiveIntervalYearMonth(LazyHiveIntervalYearMonthObjectInspector oi) {
        super(oi);
        this.data = new HiveIntervalYearMonthWritable();
    }

    public LazyHiveIntervalYearMonth(LazyHiveIntervalYearMonth copy) {
        super(copy);
        this.data = new HiveIntervalYearMonthWritable((HiveIntervalYearMonthWritable)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        String s2 = null;
        try {
            s2 = Text.decode(bytes.getData(), start, length);
            ((HiveIntervalYearMonthWritable)this.data).set(HiveIntervalYearMonth.valueOf(s2));
            this.isNull = false;
        }
        catch (Exception e) {
            this.isNull = true;
            this.logExceptionMessage(bytes, start, length, "INTERVAL_YEAR_MONTH");
        }
    }

    public static void writeUTF8(OutputStream out, HiveIntervalYearMonthWritable i) throws IOException {
        ByteBuffer b = Text.encode(i.toString());
        out.write(b.array(), 0, b.limit());
    }

    @Override
    public HiveIntervalYearMonthWritable getWritableObject() {
        return (HiveIntervalYearMonthWritable)this.data;
    }
}

