/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;

public final class SmallFilesWarningUtil {
    public static final long DEFAULT_MIN_FILES = 100L;

    private SmallFilesWarningUtil() {
    }

    public static boolean smallAverageFilesDetected(long minFiles, long avgSizeThreshold, Map<String, String> parameters) {
        long numFiles;
        long totalSize;
        if (parameters == null) {
            return false;
        }
        String ts = parameters.get("totalSize");
        String nf = parameters.get("numFiles");
        if (ts == null || nf == null) {
            return false;
        }
        try {
            totalSize = Long.parseLong(ts);
            numFiles = Long.parseLong(nf);
        }
        catch (NumberFormatException ignore) {
            return false;
        }
        if (numFiles <= minFiles || totalSize <= 0L) {
            return false;
        }
        long avg = Math.floorDiv(totalSize, numFiles);
        return avg <= avgSizeThreshold;
    }

    public static boolean smallAverageFilesDetected(Configuration conf, Map<String, String> parameters) {
        long threshold = MetastoreConf.getLongVar(conf, MetastoreConf.ConfVars.MSCK_SMALLFILES_AVG_SIZE);
        return SmallFilesWarningUtil.smallAverageFilesDetected(100L, threshold, parameters);
    }

    public static Optional<String> smallFilesWarnings(Map<String, String> parameters, long minFiles, long avgSizeThreshold, String tableOrPartName, String tagPrefix) {
        if (!SmallFilesWarningUtil.smallAverageFilesDetected(minFiles, avgSizeThreshold, parameters)) {
            return Optional.empty();
        }
        long totalSize = Long.parseLong(parameters.get("totalSize"));
        long numFiles = Long.parseLong(parameters.get("numFiles"));
        long avg = Math.floorDiv(totalSize, numFiles);
        String prefix = tagPrefix == null || tagPrefix.isEmpty() ? "" : tagPrefix + " ";
        String msg = String.format("%sSmall files detected: %s (avgBytes=%d, files=%d, totalBytes=%d)", prefix, tableOrPartName, avg, numFiles, totalSize);
        return Optional.of(msg);
    }
}

