/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.io.netty.util.NetUtil;
import org.apache.hive.org.apache.commons.lang3.StringUtils;

public class IPStackUtils {
    public static final String WILDCARD_ADDRESS_IPV4 = "0.0.0.0";
    public static final String LOOPBACK_ADDRESS_IPV4 = "127.0.0.1";
    public static final List<String> WILDCARD_ADDRESSES_IPV6 = Collections.unmodifiableList(Arrays.asList("::", "0:0:0:0:0:0:0:0"));
    public static final List<String> LOOPBACK_ADDRESSES_IPV6 = Collections.unmodifiableList(Arrays.asList("::1", "0:0:0:0:0:0:0:1"));
    private static boolean preferIPv4Stack = NetUtil.isIpV4StackPreferred();
    private static boolean preferIPv6Addresses = NetUtil.isIpV6AddressesPreferred();

    private IPStackUtils() {
    }

    @VisibleForTesting
    static void setPreferIPv4Stack(boolean preferIPv4Stack) {
        IPStackUtils.preferIPv4Stack = preferIPv4Stack;
    }

    @VisibleForTesting
    static void setPreferIPv6Addresses(boolean preferIPv6Addresses) {
        IPStackUtils.preferIPv6Addresses = preferIPv6Addresses;
    }

    public static String resolveWildcardAddress() {
        if (preferIPv4Stack) {
            return WILDCARD_ADDRESS_IPV4;
        }
        if (preferIPv6Addresses) {
            return WILDCARD_ADDRESSES_IPV6.get(0);
        }
        return WILDCARD_ADDRESS_IPV4;
    }

    public static String concatWildcardAddressPort(int port) {
        return IPStackUtils.concatHostPort(IPStackUtils.resolveWildcardAddress(), port);
    }

    public static String adaptWildcardAddress(String hostname) {
        if (WILDCARD_ADDRESS_IPV4.equals(hostname) || WILDCARD_ADDRESSES_IPV6.contains(hostname)) {
            return IPStackUtils.resolveWildcardAddress();
        }
        return hostname;
    }

    public static String adaptLoopbackAddress(String hostname) {
        if (LOOPBACK_ADDRESS_IPV4.equals(hostname) || LOOPBACK_ADDRESSES_IPV6.contains(hostname)) {
            return IPStackUtils.resolveLoopbackAddress();
        }
        return hostname;
    }

    public static String resolveLoopbackAddress() {
        if (preferIPv4Stack) {
            return LOOPBACK_ADDRESS_IPV4;
        }
        if (preferIPv6Addresses) {
            return LOOPBACK_ADDRESSES_IPV6.get(0);
        }
        return LOOPBACK_ADDRESS_IPV4;
    }

    public static boolean isActiveStackLoopbackIP(String ipAddress) {
        if (preferIPv4Stack) {
            return LOOPBACK_ADDRESS_IPV4.equals(ipAddress);
        }
        if (preferIPv6Addresses) {
            return LOOPBACK_ADDRESSES_IPV6.contains(ipAddress);
        }
        return LOOPBACK_ADDRESS_IPV4.equals(ipAddress);
    }

    public static String concatLoopbackAddressPort(int port) {
        return IPStackUtils.concatHostPort(IPStackUtils.resolveLoopbackAddress(), port);
    }

    public static String concatHostPort(String host, int port) {
        IPStackUtils.validateHostNotEmpty(host);
        IPStackUtils.validatePort(port);
        return IPStackUtils.formatIPAddressForURL(host) + ":" + port;
    }

    public static String concatHostPort(String host, String port) {
        return IPStackUtils.concatHostPort(host, Integer.parseInt(port));
    }

    public static String formatIPAddressForURL(String ipAddress) {
        if (ipAddress.contains(":") && !ipAddress.startsWith("[") && !ipAddress.endsWith("]")) {
            return "[" + ipAddress + "]";
        }
        return ipAddress;
    }

    public static String transformToIPv6(String ipv4) {
        if (NetUtil.isValidIpV4Address(ipv4)) {
            try {
                return InetAddress.getByName("::ffff:" + ipv4).getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return ipv4;
    }

    public static String transformToIPv6(String ipv4, int port) {
        if (NetUtil.isValidIpV4Address(ipv4)) {
            try {
                return IPStackUtils.concatHostPort(InetAddress.getByName("::ffff:" + ipv4).getHostAddress(), port);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return ipv4;
    }

    public static HostPort getHostAndPort(String input) {
        if (StringUtils.isEmpty(input)) {
            throw new IllegalArgumentException("Input string is null or empty");
        }
        int colonIndex = input.lastIndexOf(58);
        if (colonIndex == -1) {
            throw new IllegalArgumentException("Input does not contain a port.");
        }
        String host = input.substring(0, colonIndex);
        int port = IPStackUtils.getPort(input.substring(colonIndex + 1));
        IPStackUtils.validateHostNotEmpty(host);
        if (host.startsWith("[") && host.endsWith("]")) {
            host = host.substring(1, host.length() - 1);
        }
        return new HostPort(host, port);
    }

    public static int getPort(String portString) {
        if (StringUtils.isEmpty(portString)) {
            throw new IllegalArgumentException("port is null or empty");
        }
        int port = Integer.parseInt(portString);
        IPStackUtils.validatePort(port);
        return port;
    }

    private static void validateHostNotEmpty(String host) {
        if (StringUtils.isEmpty(host) || host.equals("[]")) {
            throw new IllegalArgumentException("Host address is null or empty.");
        }
    }

    private static void validatePort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port number out of range (0-65535).");
        }
    }

    public static class HostPort {
        private final String hostname;
        private final int port;

        public HostPort(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }
    }
}

