/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseFilesTable;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;

public class AllFilesTable
extends BaseFilesTable {
    AllFilesTable(Table table) {
        this(table, table.name() + ".all_files");
    }

    AllFilesTable(Table table, String name) {
        super(table, name);
    }

    @Override
    public TableScan newScan() {
        return new AllFilesTableScan(this.table(), this.schema());
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.ALL_FILES;
    }

    public static class AllFilesTableScan
    extends BaseFilesTable.BaseAllFilesTableScan {
        AllFilesTableScan(Table table, Schema schema) {
            super(table, schema, MetadataTableType.ALL_FILES);
        }

        private AllFilesTableScan(Table table, Schema schema, TableScanContext context) {
            super(table, schema, MetadataTableType.ALL_FILES, context);
        }

        @Override
        protected TableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
            return new AllFilesTableScan(table, schema, context);
        }

        @Override
        protected CloseableIterable<ManifestFile> manifests() {
            return this.reachableManifests(snapshot -> snapshot.allManifests(this.table().io()));
        }
    }
}

