/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.registry.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstanceSet;
import org.apache.hadoop.hive.llap.registry.ServiceRegistry;
import org.apache.hadoop.hive.registry.ServiceInstanceStateChangeListener;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapFixedRegistryImpl
implements ServiceRegistry<LlapServiceInstance> {
    private static final Logger LOG = LoggerFactory.getLogger(LlapFixedRegistryImpl.class);
    @InterfaceAudience.Private
    public static final String FIXED_REGISTRY_RESOLVE_HOST_NAMES = "fixed.registry.resolve.host.names";
    private final int port;
    private final int shuffle;
    private final int mngPort;
    private final int webPort;
    private Configuration conf;
    private final int outputFormatPort;
    private final int externalClientsRpcPort;
    private final String webScheme;
    private final String[] hosts;
    private final int memory;
    private final int vcores;
    private final boolean resolveHosts;
    private final Map<String, String> srv = new HashMap<String, String>();

    public LlapFixedRegistryImpl(String hosts, Configuration conf) {
        this.hosts = hosts.split(",");
        this.port = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_RPC_PORT);
        this.shuffle = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_YARN_SHUFFLE_PORT);
        this.resolveHosts = conf.getBoolean(FIXED_REGISTRY_RESOLVE_HOST_NAMES, true);
        this.mngPort = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_MANAGEMENT_RPC_PORT);
        this.outputFormatPort = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_OUTPUT_SERVICE_PORT);
        this.externalClientsRpcPort = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_EXTERNAL_CLIENT_CLOUD_RPC_PORT);
        this.webPort = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_WEB_PORT);
        this.conf = conf;
        boolean isSsl = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_WEB_SSL);
        this.webScheme = isSsl ? "https" : "http";
        for (Map.Entry kv : conf) {
            if (!((String)kv.getKey()).startsWith("llap.") && !((String)kv.getKey()).startsWith("hive.llap.")) continue;
            this.srv.put((String)kv.getKey(), (String)kv.getValue());
        }
        this.memory = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB);
        this.vcores = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS);
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void stop() throws IOException {
    }

    @Override
    public String register() throws IOException {
        return LlapFixedRegistryImpl.getWorkerIdentity(InetAddress.getLocalHost().getCanonicalHostName());
    }

    @Override
    public void unregister() throws IOException {
    }

    @Override
    public void updateRegistration(Iterable<Map.Entry<String, String>> attributes) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static String getWorkerIdentity(String host) {
        return "host-" + host;
    }

    public LlapServiceInstanceSet getInstances(String component, long timeoutMs) throws IOException {
        return new FixedServiceInstanceSet(this);
    }

    @Override
    public void registerStateChangeListener(ServiceInstanceStateChangeListener listener) throws IOException {
        LOG.warn("Callbacks for instance state changes are not supported in fixed registry.");
    }

    public String toString() {
        return String.format("FixedRegistry hosts=%s", StringUtils.join((CharSequence)",", (String[])this.hosts));
    }

    @Override
    public ApplicationId getApplicationId() throws IOException {
        return null;
    }

    private final class FixedServiceInstanceSet
    implements LlapServiceInstanceSet {
        private final Map<String, LlapServiceInstance> instances = new LinkedHashMap<String, LlapServiceInstance>();

        public FixedServiceInstanceSet(LlapFixedRegistryImpl llapFixedRegistryImpl) {
            for (String host : llapFixedRegistryImpl.hosts) {
                this.instances.put(LlapFixedRegistryImpl.getWorkerIdentity(host), llapFixedRegistryImpl.new FixedServiceInstance(host));
            }
        }

        @Override
        public Collection<LlapServiceInstance> getAll() {
            return this.instances.values();
        }

        public List<LlapServiceInstance> getAllInstancesOrdered(boolean consistentIndexes) {
            LinkedList<LlapServiceInstance> list = new LinkedList<LlapServiceInstance>();
            list.addAll(this.instances.values());
            Collections.sort(list, new Comparator<LlapServiceInstance>(this){

                @Override
                public int compare(LlapServiceInstance o1, LlapServiceInstance o2) {
                    return o1.getWorkerIdentity().compareTo(o2.getWorkerIdentity());
                }
            });
            return list;
        }

        @Override
        public LlapServiceInstance getInstance(String name) {
            return this.instances.get(name);
        }

        @Override
        public Set<LlapServiceInstance> getByHost(String host) {
            HashSet<LlapServiceInstance> byHost = new HashSet<LlapServiceInstance>();
            LlapServiceInstance inst = this.getInstance(LlapFixedRegistryImpl.getWorkerIdentity(host));
            if (inst != null) {
                byHost.add(inst);
            }
            return byHost;
        }

        @Override
        public int size() {
            return this.instances.size();
        }

        @Override
        public ApplicationId getApplicationId() {
            return null;
        }
    }

    @VisibleForTesting
    public final class FixedServiceInstance
    implements LlapServiceInstance {
        private final String host;
        private final String serviceAddress;

        public FixedServiceInstance(String host) {
            if (LlapFixedRegistryImpl.this.resolveHosts) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(host);
                    if (NetUtils.isLocalAddress((InetAddress)inetAddress)) {
                        InetSocketAddress socketAddress = new InetSocketAddress(0);
                        socketAddress = NetUtils.getConnectAddress((InetSocketAddress)socketAddress);
                        LOG.info("Adding host identified as local: " + host + " as " + socketAddress.getHostName());
                        host = socketAddress.getHostName();
                    }
                }
                catch (UnknownHostException e) {
                    LOG.warn("Ignoring resolution issues for host: " + host, (Throwable)e);
                }
            }
            this.host = host;
            try {
                URL serviceURL = new URL(LlapFixedRegistryImpl.this.webScheme, host, LlapFixedRegistryImpl.this.webPort, "");
                this.serviceAddress = serviceURL.toString();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getWorkerIdentity() {
            return LlapFixedRegistryImpl.getWorkerIdentity(this.host);
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public int getRpcPort() {
            return LlapFixedRegistryImpl.this.port;
        }

        @Override
        public int getManagementPort() {
            return LlapFixedRegistryImpl.this.mngPort;
        }

        @Override
        public int getShufflePort() {
            return LlapFixedRegistryImpl.this.shuffle;
        }

        @Override
        public int getOutputFormatPort() {
            return LlapFixedRegistryImpl.this.outputFormatPort;
        }

        @Override
        public String getExternalHostname() {
            this.ensureCloudEnv(LlapFixedRegistryImpl.this.conf);
            return LlapUtil.getPublicHostname();
        }

        @Override
        public int getExternalClientsRpcPort() {
            this.ensureCloudEnv(LlapFixedRegistryImpl.this.conf);
            return LlapFixedRegistryImpl.this.externalClientsRpcPort;
        }

        @Override
        public String getServicesAddress() {
            return this.serviceAddress;
        }

        @Override
        public Map<String, String> getProperties() {
            HashMap<String, String> properties = new HashMap<String, String>(LlapFixedRegistryImpl.this.srv);
            return properties;
        }

        @Override
        public Resource getResource() {
            return Resource.newInstance((int)LlapFixedRegistryImpl.this.memory, (int)LlapFixedRegistryImpl.this.vcores);
        }

        public String toString() {
            return "FixedServiceInstance{host=" + this.host + ", memory=" + LlapFixedRegistryImpl.this.memory + ", vcores=" + LlapFixedRegistryImpl.this.vcores + "}";
        }
    }
}

