/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api;

import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.io.api.LlapIo;

public class LlapProxy {
    private static final String IO_IMPL_CLASS = "org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl";
    private static LlapIo io = null;
    private static boolean isDaemon = false;

    public static void setDaemon(boolean isDaemon) {
        LlapProxy.isDaemon = isDaemon;
    }

    public static boolean isDaemon() {
        return isDaemon;
    }

    public static LlapIo getIo() {
        return io;
    }

    public static void initializeLlapIo(Configuration conf) {
        if (io != null) {
            return;
        }
        io = (LlapIo)LlapProxy.createInstance(IO_IMPL_CLASS, conf);
    }

    private static <T> T createInstance(String className, Configuration conf) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> ctor = clazz.getDeclaredConstructor(Configuration.class);
            ctor.setAccessible(true);
            return (T)ctor.newInstance(conf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create " + className, e);
        }
    }

    public static void close() {
        if (io != null) {
            io.close();
        }
    }
}

