/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.sps.Context;
import org.apache.hadoop.hdfs.server.namenode.sps.SPSService;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;
import org.apache.hadoop.hdfs.server.sps.ExternalSPSContext;
import org.apache.hadoop.hdfs.tools.StoragePolicyAdmin;
import org.apache.hadoop.util.Tool;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestStoragePolicySatisfyAdminCommands {
    private static final short REPL = 1;
    private static final int SIZE = 128;
    private Configuration conf = null;
    private MiniDFSCluster cluster = null;
    private DistributedFileSystem dfs = null;
    private StoragePolicySatisfier externalSps = null;

    @Before
    public void clusterSetUp() throws IOException, URISyntaxException {
        this.conf = new HdfsConfiguration();
        this.conf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        this.conf.setLong("dfs.storage.policy.satisfier.datanode.cache.refresh.interval.ms", 1000L);
        StorageType[][] newtypes = new StorageType[][]{{StorageType.ARCHIVE, StorageType.DISK}};
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).storageTypes(newtypes).build();
        this.cluster.waitActive();
        this.dfs = this.cluster.getFileSystem();
        NameNodeConnector nnc = DFSTestUtil.getNameNodeConnector(this.conf, HdfsServerConstants.MOVER_ID_PATH, 1, false);
        StoragePolicySatisfier externalSps = new StoragePolicySatisfier(this.conf);
        ExternalSPSContext externalCtxt = new ExternalSPSContext((SPSService)externalSps, nnc);
        externalSps.init((Context)externalCtxt);
        externalSps.start(HdfsConstants.StoragePolicySatisfierMode.EXTERNAL);
    }

    @After
    public void clusterShutdown() throws IOException {
        if (this.dfs != null) {
            this.dfs.close();
            this.dfs = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        if (this.externalSps != null) {
            this.externalSps.stopGracefully();
        }
    }

    @Test(timeout=30000L)
    public void testStoragePolicySatisfierCommand() throws Exception {
        String file = "/testStoragePolicySatisfierCommand";
        DFSTestUtil.createFile((FileSystem)this.dfs, new Path("/testStoragePolicySatisfierCommand"), 128L, (short)1, 0L);
        StoragePolicyAdmin admin = new StoragePolicyAdmin(this.conf);
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /testStoragePolicySatisfierCommand", 0, "The storage policy of /testStoragePolicySatisfierCommand is unspecified");
        DFSTestUtil.toolRun((Tool)admin, "-setStoragePolicy -path /testStoragePolicySatisfierCommand -policy COLD", 0, "Set storage policy COLD on " + "/testStoragePolicySatisfierCommand".toString());
        DFSTestUtil.toolRun((Tool)admin, "-satisfyStoragePolicy -path /testStoragePolicySatisfierCommand", 0, "Scheduled blocks to move based on the current storage policy on " + "/testStoragePolicySatisfierCommand".toString());
        DFSTestUtil.waitExpectedStorageType("/testStoragePolicySatisfierCommand", StorageType.ARCHIVE, 1, 30000, this.dfs);
    }

    @Test(timeout=30000L)
    public void testStoragePolicySatisfierCommandWithURI() throws Exception {
        String file = "/testStoragePolicySatisfierCommandURI";
        DFSTestUtil.createFile((FileSystem)this.dfs, new Path("/testStoragePolicySatisfierCommandURI"), 128L, (short)1, 0L);
        StoragePolicyAdmin admin = new StoragePolicyAdmin(this.conf);
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /testStoragePolicySatisfierCommandURI", 0, "The storage policy of /testStoragePolicySatisfierCommandURI is unspecified");
        DFSTestUtil.toolRun((Tool)admin, "-setStoragePolicy -path /testStoragePolicySatisfierCommandURI -policy COLD", 0, "Set storage policy COLD on " + "/testStoragePolicySatisfierCommandURI".toString());
        DFSTestUtil.toolRun((Tool)admin, "-satisfyStoragePolicy -path " + this.dfs.getUri() + "/testStoragePolicySatisfierCommandURI", 0, "Scheduled blocks to move based on the current storage policy on " + this.dfs.getUri() + "/testStoragePolicySatisfierCommandURI".toString());
        DFSTestUtil.waitExpectedStorageType("/testStoragePolicySatisfierCommandURI", StorageType.ARCHIVE, 1, 30000, this.dfs);
    }
}

