/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestFSNamesystemLockReport {
    private Configuration conf;
    private MiniDFSCluster cluster;
    private FileSystem fs;
    private UserGroupInformation userGroupInfo;
    private GenericTestUtils.LogCapturer logs;

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.set("dfs.permissions.superusergroup", "hadoop");
        this.conf.setLong("dfs.namenode.read-lock-reporting-threshold-ms", 0L);
        this.conf.setLong("dfs.namenode.write-lock-reporting-threshold-ms", 0L);
        this.conf.setLong("dfs.lock.suppress.warning.interval", 0L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(4).build();
        this.fs = this.cluster.getFileSystem();
        this.userGroupInfo = UserGroupInformation.createUserForTesting((String)"bob", (String[])new String[]{"hadoop"});
        this.logs = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.LOG);
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger((String)FSNamesystem.class.getName()), (Level)Level.INFO);
    }

    @After
    public void cleanUp() throws Exception {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void test() throws Exception {
        FileSystem userfs = DFSTestUtil.getFileSystemAs(this.userGroupInfo, this.conf);
        FSDataOutputStream os = this.testLockReport(() -> userfs.create(new Path("/file")), ".* by create \\(ugi=bob \\(auth:SIMPLE\\),ip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3},src=/file,dst=null,perm=bob:hadoop:rw-r--r--\\) .*");
        os.close();
        FSDataInputStream is = this.testLockReport(() -> userfs.open(new Path("/file")), ".* by open \\(ugi=bob \\(auth:SIMPLE\\),ip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3},src=/file,dst=null,perm=null\\) .*");
        is.close();
        this.testLockReport(() -> userfs.setPermission(new Path("/file"), new FsPermission(644)), ".* by setPermission \\(ugi=bob \\(auth:SIMPLE\\),ip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3},src=/file,dst=null,perm=bob:hadoop:-w----r-T\\) .*");
        this.testLockReport(() -> userfs.setOwner(new Path("/file"), "alice", "group1"), ".* by setOwner \\(ugi=bob \\(auth:SIMPLE\\),ip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3},src=/file,dst=null,perm=alice:group1:-w----r-T\\) .*");
        this.testLockReport(() -> userfs.listStatus(new Path("/")), ".* by listStatus \\(ugi=bob \\(auth:SIMPLE\\),ip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3},src=/,dst=null,perm=null\\) .*");
        this.testLockReport(() -> userfs.getFileStatus(new Path("/file")), ".* by getfileinfo \\(ugi=bob \\(auth:SIMPLE\\),ip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3},src=/file,dst=null,perm=null\\) .*");
        this.testLockReport(() -> userfs.mkdirs(new Path("/dir")), ".* by mkdirs \\(ugi=bob \\(auth:SIMPLE\\),ip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3},src=/dir,dst=null,perm=bob:hadoop:rwxr-xr-x\\) .*");
        this.testLockReport(() -> userfs.rename(new Path("/file"), new Path("/file2")), ".* by rename \\(ugi=bob \\(auth:SIMPLE\\),ip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3},src=/file,dst=/file2,perm=alice:group1:-w----r-T\\) .*");
        this.testLockReport(() -> userfs.delete(new Path("/file2"), false), ".* by delete \\(ugi=bob \\(auth:SIMPLE\\),ip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3},src=/file2,dst=null,perm=null\\) .*");
    }

    private void testLockReport(Procedure procedure, String expectedLockReportRegex) throws Exception {
        this.logs.clearOutput();
        this.userGroupInfo.doAs(() -> {
            procedure.invoke();
            return null;
        });
        Assert.assertTrue((boolean)this.matches(expectedLockReportRegex));
    }

    private <T> T testLockReport(SupplierWithException<T> supplier, String expectedLockReportRegex) throws Exception {
        this.logs.clearOutput();
        Object ret = this.userGroupInfo.doAs(supplier::get);
        Assert.assertTrue((boolean)this.matches(expectedLockReportRegex));
        return (T)ret;
    }

    private boolean matches(String regex) {
        for (String line : this.logs.getOutput().split(System.lineSeparator())) {
            if (!line.matches(regex)) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    private static interface Procedure {
        public void invoke() throws Exception;
    }

    @FunctionalInterface
    private static interface SupplierWithException<T> {
        public T get() throws Exception;
    }
}

