/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.compaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.compaction.MajorCompactionTTLRequest;
import org.apache.hadoop.hbase.util.compaction.TestMajorCompactionRequest;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestMajorCompactionTTLRequest
extends TestMajorCompactionRequest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMajorCompactionTTLRequest.class);

    @Override
    @Before
    public void setUp() throws Exception {
        this.rootRegionDir = UTILITY.getDataTestDirOnTestFS("TestMajorCompactionTTLRequest");
        this.regionStoreDir = new Path(this.rootRegionDir, "a");
    }

    @Override
    @Test
    public void testStoresNeedingCompaction() throws Exception {
        List<StoreFileInfo> storeFiles1 = this.mockStoreFiles(this.regionStoreDir, 5, 10L);
        List<StoreFileInfo> storeFiles2 = this.mockStoreFiles(this.regionStoreDir, 5, 100L);
        ArrayList storeFiles = Lists.newArrayList(storeFiles1);
        storeFiles.addAll(storeFiles2);
        MajorCompactionTTLRequest request = this.makeMockRequest(storeFiles);
        Optional result = request.createRequest((Connection)Mockito.mock(Connection.class), (Set)Sets.newHashSet((Object[])new String[]{"a"}), 10L);
        Assert.assertFalse((boolean)result.isPresent());
        result = request.createRequest((Connection)Mockito.mock(Connection.class), (Set)Sets.newHashSet((Object[])new String[]{"a"}), 100L);
        Assert.assertFalse((boolean)result.isPresent());
        result = request.createRequest((Connection)Mockito.mock(Connection.class), (Set)Sets.newHashSet((Object[])new String[]{"a"}), 101L);
        Assert.assertTrue((boolean)result.isPresent());
    }

    private MajorCompactionTTLRequest makeMockRequest(List<StoreFileInfo> storeFiles) throws IOException {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RegionInfo regionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)regionInfo.getEncodedName()).thenReturn((Object)"HBase");
        Mockito.when((Object)regionInfo.getTable()).thenReturn((Object)TableName.valueOf((String)"foo"));
        MajorCompactionTTLRequest request = new MajorCompactionTTLRequest(connection, regionInfo);
        MajorCompactionTTLRequest spy = (MajorCompactionTTLRequest)Mockito.spy((Object)request);
        HRegionFileSystem fileSystem = this.mockFileSystem(regionInfo, false, storeFiles);
        ((MajorCompactionTTLRequest)Mockito.doReturn((Object)fileSystem).when((Object)spy)).getFileSystem();
        return spy;
    }
}

