/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.mob.MobStressToolRunner;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MobStressTool
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger(MobStressTool.class);
    private CommandLine cmd;

    public MobStressTool() throws IOException {
        this.init();
    }

    protected void init() throws IOException {
        this.addOptWithArg("n", "Number of MOB key-values to insert, default - 10000000");
    }

    protected void addOptions() {
    }

    protected void processOptions(CommandLine cmd) {
        this.cmd = cmd;
    }

    protected int doWork() throws Exception {
        long numRowsToInsert = 10000000L;
        if (this.cmd.hasOption("n") && (numRowsToInsert = Long.parseLong(this.cmd.getOptionValue("n"))) < 0L) {
            LOG.warn("Ignore wrong option '-n'");
            numRowsToInsert = 10000000L;
        }
        MobStressToolRunner runner = new MobStressToolRunner();
        runner.init(this.getConf(), numRowsToInsert);
        runner.runStressTest();
        return 0;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Configuration)conf, (Tool)new MobStressTool(), (String[])args);
        System.exit(ret);
    }
}

