/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestBalancerDecision
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBalancerDecision.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBalancerDecisions() {
        conf.setBoolean("hbase.master.balancer.decision.buffer.enabled", true);
        loadBalancer.onConfigurationChange(conf);
        float minCost = conf.getFloat("hbase.master.balancer.stochastic.minCostNeedBalance", 0.05f);
        float slop = conf.getFloat("hbase.regions.slop", 0.2f);
        conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", 1.0f);
        conf.setFloat("hbase.regions.slop", -1.0f);
        try {
            boolean[] perTableBalancerConfigs;
            for (boolean isByTable : perTableBalancerConfigs = new boolean[]{true, false}) {
                conf.setBoolean("hbase.master.loadbalance.bytable", isByTable);
                loadBalancer.onConfigurationChange(conf);
                for (int[] mockCluster : this.clusterStateMocks) {
                    TreeMap<ServerName, List<RegionInfo>> servers = this.mockClusterServers(mockCluster);
                    HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> LoadOfAllTable = this.mockClusterServersWithTables(servers);
                    List plans = loadBalancer.balanceCluster(LoadOfAllTable);
                    boolean emptyPlans = plans == null || plans.isEmpty();
                    Assert.assertTrue((emptyPlans || TestBalancerDecision.needsBalanceIdleRegion(mockCluster) ? 1 : 0) != 0);
                }
            }
            NamedQueueGetRequest namedQueueGetRequest = new NamedQueueGetRequest();
            namedQueueGetRequest.setNamedQueueEvent(1);
            namedQueueGetRequest.setBalancerDecisionsRequest(MasterProtos.BalancerDecisionsRequest.getDefaultInstance());
            NamedQueueGetResponse namedQueueGetResponse = TestBalancerDecision.loadBalancer.namedQueueRecorder.getNamedQueueRecords(namedQueueGetRequest);
            List balancerDecisions = namedQueueGetResponse.getBalancerDecisions();
            MasterProtos.BalancerDecisionsResponse response = MasterProtos.BalancerDecisionsResponse.newBuilder().addAllBalancerDecision((Iterable)balancerDecisions).build();
            List balancerDecisionRecords = ProtobufUtil.getBalancerDecisionEntries((MasterProtos.BalancerDecisionsResponse)response);
            Assert.assertTrue((balancerDecisionRecords.size() > 160 ? 1 : 0) != 0);
        }
        finally {
            conf.unset("hbase.master.loadbalance.bytable");
            conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", minCost);
            conf.setFloat("hbase.regions.slop", slop);
            loadBalancer.onConfigurationChange(conf);
        }
    }

    private static boolean needsBalanceIdleRegion(int[] cluster) {
        return Arrays.stream(cluster).anyMatch(x -> x > 1) && Arrays.stream(cluster).anyMatch(x -> x < 1);
    }
}

