/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.ipc.BufferChain;
import org.apache.hadoop.hbase.ipc.CellBlockBuilder;
import org.apache.hadoop.hbase.ipc.NettyServerCall;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RPCTests.class, MediumTests.class})
public class TestServerCall {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestServerCall.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestServerCall.class);
    private Configuration conf;
    private NettyServerRpcConnection mockConnection;
    private RPCProtos.RequestHeader header;
    private Message mockParam;
    private ByteBuffAllocator mockAllocator;
    private CellBlockBuilder mockCellBlockBuilder;
    private InetAddress lbAddr;
    private BlockingService mockService;
    private Descriptors.MethodDescriptor mockMethodDescriptor;

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create();
        this.mockConnection = (NettyServerRpcConnection)Mockito.mock(NettyServerRpcConnection.class);
        this.header = RPCProtos.RequestHeader.newBuilder().setCallId(1).setMethodName("testMethod").setRequestParam(true).build();
        this.mockParam = (Message)Mockito.mock(Message.class);
        this.mockAllocator = (ByteBuffAllocator)Mockito.mock(ByteBuffAllocator.class);
        this.mockCellBlockBuilder = (CellBlockBuilder)Mockito.mock(CellBlockBuilder.class);
        this.lbAddr = InetAddress.getLoopbackAddress();
        this.mockMethodDescriptor = (Descriptors.MethodDescriptor)AdminProtos.AdminService.getDescriptor().getMethods().get(0);
        this.mockService = (BlockingService)Mockito.mock(BlockingService.class);
        this.mockConnection.codec = (Codec)Mockito.mock(Codec.class);
        Mockito.when((Object)this.mockAllocator.isReservoirEnabled()).thenReturn((Object)false);
    }

    @Test
    public void testSetResponseWithIOException() throws Exception {
        CellBlockBuilder failingCellBlockBuilder = (CellBlockBuilder)Mockito.mock(CellBlockBuilder.class);
        ((CellBlockBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Test IOException during buildCellBlock")}).when((Object)failingCellBlockBuilder)).buildCellBlock((Codec)ArgumentMatchers.any(), (CompressionCodec)ArgumentMatchers.any(), (CellScanner)ArgumentMatchers.any());
        NettyServerCall call = new NettyServerCall(1, this.mockService, this.mockMethodDescriptor, this.header, this.mockParam, null, this.mockConnection, 100L, this.lbAddr, System.currentTimeMillis(), 60000, this.mockAllocator, failingCellBlockBuilder, null);
        Message mockResponse = (Message)Mockito.mock(Message.class);
        CellScanner mockCellScanner = (CellScanner)Mockito.mock(CellScanner.class);
        LOG.info("Testing setResponse with IOException in buildCellBlock");
        call.setResponse(mockResponse, mockCellScanner, null, null);
        BufferChain response = call.getResponse();
        Assert.assertNotNull((String)"Response should not be null even when IOException occurs", (Object)response);
        Assert.assertTrue((String)"Call should be marked as error", (boolean)call.isError);
        ByteBuffer[] bufs = response.getBuffers();
        Assert.assertNotNull((String)"Response buffers should not be null", (Object)bufs);
        Assert.assertTrue((String)"Response should have at least one buffer", (bufs.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetResponseWithDoubleIOException() throws Exception {
        CellBlockBuilder failingCellBlockBuilder = (CellBlockBuilder)Mockito.mock(CellBlockBuilder.class);
        ((CellBlockBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Test IOException")}).when((Object)failingCellBlockBuilder)).buildCellBlock((Codec)ArgumentMatchers.any(), (CompressionCodec)ArgumentMatchers.any(), (CellScanner)ArgumentMatchers.any());
        NettyServerCall call = new NettyServerCall(1, this.mockService, this.mockMethodDescriptor, this.header, this.mockParam, null, this.mockConnection, 100L, this.lbAddr, System.currentTimeMillis(), 60000, this.mockAllocator, failingCellBlockBuilder, null);
        Message mockResponse = (Message)Mockito.mock(Message.class);
        CellScanner mockCellScanner = (CellScanner)Mockito.mock(CellScanner.class);
        call.setResponse(mockResponse, mockCellScanner, null, null);
        Assert.assertTrue((String)"Call should be marked as error", (boolean)call.isError);
    }

    @Test
    public void testSetResponseNormalFlow() throws Exception {
        CellBlockBuilder normalCellBlockBuilder = (CellBlockBuilder)Mockito.mock(CellBlockBuilder.class);
        Mockito.when((Object)normalCellBlockBuilder.buildCellBlock((Codec)ArgumentMatchers.any(), (CompressionCodec)ArgumentMatchers.any(), (CellScanner)ArgumentMatchers.any())).thenReturn(null);
        NettyServerCall call = new NettyServerCall(1, this.mockService, this.mockMethodDescriptor, this.header, this.mockParam, null, this.mockConnection, 100L, this.lbAddr, System.currentTimeMillis(), 60000, this.mockAllocator, normalCellBlockBuilder, null);
        RPCProtos.CellBlockMeta mockResponse = RPCProtos.CellBlockMeta.newBuilder().setLength(0).build();
        LOG.info("Testing normal setResponse flow");
        call.setResponse((Message)mockResponse, null, null, null);
        BufferChain response = call.getResponse();
        Assert.assertNotNull((String)"Response should not be null in normal flow", (Object)response);
        Assert.assertTrue((String)"Call should not be marked as error in normal flow", (!call.isError ? 1 : 0) != 0);
    }
}

