/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.CellCodec;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.codec.MessageCodec;
import org.apache.hadoop.hbase.io.CellOutputStream;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class CodecPerformance {
    @Deprecated
    public static final Logger LOG = LoggerFactory.getLogger(CodecPerformance.class);

    static Cell[] getCells(int howMany) {
        Cell[] cells = new Cell[howMany];
        for (int i = 0; i < howMany; ++i) {
            byte[] index = Bytes.toBytes((int)i);
            KeyValue kv = new KeyValue(index, Bytes.toBytes((String)"f"), index, index);
            cells[i] = kv;
        }
        return cells;
    }

    static int getRoughSize(Cell[] cells) {
        int size = 0;
        for (Cell c : cells) {
            size += c.getRowLength() + c.getFamilyLength() + c.getQualifierLength() + c.getValueLength();
            size += 9;
        }
        return size;
    }

    static byte[] runEncoderTest(int index, int initialBufferSize, ByteArrayOutputStream baos, CellOutputStream encoder, Cell[] cells) throws IOException {
        long startTime = EnvironmentEdgeManager.currentTime();
        for (int i = 0; i < cells.length; ++i) {
            encoder.write(cells[i]);
        }
        encoder.flush();
        LOG.info("" + index + " encoded count=" + cells.length + " in " + (EnvironmentEdgeManager.currentTime() - startTime) + "ms for encoder " + encoder);
        Assert.assertTrue((baos.size() < initialBufferSize ? 1 : 0) != 0);
        return baos.toByteArray();
    }

    static Cell[] runDecoderTest(int index, int count, CellScanner decoder) throws IOException {
        Cell[] cells = new Cell[count];
        long startTime = EnvironmentEdgeManager.currentTime();
        int i = 0;
        while (decoder.advance()) {
            cells[i] = decoder.current();
            ++i;
        }
        LOG.info("" + index + " decoded count=" + cells.length + " in " + (EnvironmentEdgeManager.currentTime() - startTime) + "ms for decoder " + decoder);
        Assert.assertTrue((cells.length == count ? 1 : 0) != 0);
        return cells;
    }

    static void verifyCells(Cell[] input, Cell[] output) {
        Assert.assertArrayEquals((Object[])input, (Object[])output);
    }

    static void doCodec(Codec codec, Cell[] cells, int cycles, int count, int initialBufferSize) throws IOException {
        int i;
        byte[] bytes = null;
        Cell[] cellsDecoded = null;
        for (i = 0; i < cycles; ++i) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(initialBufferSize);
            Codec.Encoder encoder = codec.getEncoder((OutputStream)baos);
            bytes = CodecPerformance.runEncoderTest(i, initialBufferSize, baos, (CellOutputStream)encoder, cells);
        }
        for (i = 0; i < cycles; ++i) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            Codec.Decoder decoder = codec.getDecoder((InputStream)bais);
            cellsDecoded = CodecPerformance.runDecoderTest(i, count, (CellScanner)decoder);
        }
        CodecPerformance.verifyCells(cells, cellsDecoded);
    }

    public static void main(String[] args) throws IOException {
        int count = 100000;
        int cycles = 30;
        Cell[] cells = CodecPerformance.getCells(100000);
        int size = CodecPerformance.getRoughSize(cells);
        int initialBufferSize = 2 * size;
        CodecPerformance.doCodec((Codec)new KeyValueCodec(), cells, 30, 100000, initialBufferSize);
        CodecPerformance.doCodec((Codec)new CellCodec(), cells, 30, 100000, initialBufferSize);
        CodecPerformance.doCodec((Codec)new MessageCodec(), cells, 30, 100000, initialBufferSize);
    }
}

