/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestAsyncClusterAdminApi2
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncClusterAdminApi2.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 60000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 120000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.client.start.log.errors.counter", 0);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Override
    @Before
    public void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        this.admin = ASYNC_CONN.getAdmin();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        Closeables.close((Closeable)ASYNC_CONN, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testStop() throws Exception {
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        Assert.assertFalse((boolean)rs.isStopped());
        this.admin.stopRegionServer(rs.getServerName()).join();
        Assert.assertTrue((boolean)rs.isStopped());
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        Assert.assertFalse((boolean)master.isStopped());
        this.admin.stopMaster().join();
        Assert.assertTrue((boolean)master.isStopped());
    }

    @Test
    public void testShutdown() throws Exception {
        TEST_UTIL.getMiniHBaseCluster().getMasterThreads().forEach(thread -> Assert.assertFalse((boolean)thread.getMaster().isStopped()));
        TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads().forEach(thread -> Assert.assertFalse((boolean)thread.getRegionServer().isStopped()));
        this.admin.shutdown().join();
        TEST_UTIL.getMiniHBaseCluster().getMasterThreads().forEach(thread -> {
            while (!thread.getMaster().isStopped()) {
                this.trySleep(100L, TimeUnit.MILLISECONDS);
            }
        });
        TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads().forEach(thread -> {
            while (!thread.getRegionServer().isStopped()) {
                this.trySleep(100L, TimeUnit.MILLISECONDS);
            }
        });
    }

    private void trySleep(long timeout, TimeUnit unit) {
        try {
            unit.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

