/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.mapred.LocalContainerLauncher;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.v2.hs.JobHistoryServer;
import org.apache.hadoop.mapreduce.v2.jobhistory.JHAdminConfig;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DefaultContainerExecutor;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MiniMRYarnCluster
extends MiniYARNCluster {
    public static final String APPJAR = JarFinder.getJar(LocalContainerLauncher.class);
    private static final Logger LOG = LoggerFactory.getLogger(MiniMRYarnCluster.class);
    private JobHistoryServer historyServer;
    private JobHistoryServerWrapper historyServerWrapper;
    private static final String TIMELINE_AUX_SERVICE_NAME = "timeline_collector";
    public static final String MR_HISTORY_MINICLUSTER_ENABLED = "mapreduce.jobhistory.minicluster.enabled";
    public static final String MR_HISTORY_MINICLUSTER_LAUNCH_TIMEOUT_MS = "mapreduce.jobhistory.minicluster.launch.timeout.ms";

    public MiniMRYarnCluster(String testName) {
        this(testName, 1);
    }

    public MiniMRYarnCluster(String testName, int noOfNMs) {
        this(testName, noOfNMs, false);
    }

    @Deprecated
    public MiniMRYarnCluster(String testName, int noOfNMs, boolean enableAHS) {
        super(testName, 1, noOfNMs, 4, 4, enableAHS);
    }

    public static String copyAppJarIntoTestDir(String testSubdir) {
        return JarFinder.getJar(LocalContainerLauncher.class, (String)testSubdir);
    }

    public static String getResolvedMRHistoryWebAppURLWithoutScheme(Configuration conf, boolean isSSLEnabled) {
        InetSocketAddress address = null;
        address = isSSLEnabled ? conf.getSocketAddr("mapreduce.jobhistory.webapp.https.address", "0.0.0.0:19890", 19890) : conf.getSocketAddr("mapreduce.jobhistory.webapp.address", "0.0.0.0:19888", 19888);
        address = NetUtils.getConnectAddress((InetSocketAddress)address);
        StringBuffer sb = new StringBuffer();
        InetAddress resolved = address.getAddress();
        if (resolved == null || resolved.isAnyLocalAddress() || resolved.isLoopbackAddress()) {
            String lh = address.getHostName();
            try {
                lh = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            sb.append(lh);
        } else {
            sb.append(address.getHostName());
        }
        sb.append(":").append(address.getPort());
        return sb.toString();
    }

    public void serviceInit(Configuration conf) throws Exception {
        if (conf.getBoolean(MR_HISTORY_MINICLUSTER_ENABLED, true)) {
            this.historyServerWrapper = new JobHistoryServerWrapper();
            this.addService((Service)this.historyServerWrapper);
        }
        conf.set("mapreduce.framework.name", "yarn");
        String stagingDir = conf.get("yarn.app.mapreduce.am.staging-dir");
        if (stagingDir == null || stagingDir.equals("/tmp/hadoop-yarn/staging")) {
            conf.set("yarn.app.mapreduce.am.staging-dir", new File(this.getTestWorkDir(), "apps_staging_dir/").getAbsolutePath());
        }
        if (!conf.getBoolean("mapreduce.minicluster.control-resource-monitoring", false)) {
            conf.setBoolean("yarn.nodemanager.pmem-check-enabled", false);
            conf.setBoolean("yarn.nodemanager.vmem-check-enabled", false);
        }
        conf.set("fs.permissions.umask-mode", "000");
        try {
            FileContext fc;
            Path stagingPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(conf.get("yarn.app.mapreduce.am.staging-dir")));
            if (Path.WINDOWS && LocalFileSystem.class.isInstance(stagingPath.getFileSystem(conf))) {
                conf.set("yarn.app.mapreduce.am.staging-dir", new File(conf.get("yarn.app.mapreduce.am.staging-dir")).getAbsolutePath());
            }
            if ((fc = FileContext.getFileContext((URI)stagingPath.toUri(), (Configuration)conf)).util().exists(stagingPath)) {
                LOG.info(stagingPath + " exists! deleting...");
                fc.delete(stagingPath, true);
            }
            LOG.info("mkdir: " + stagingPath);
            fc.mkdir(stagingPath, null, true);
            String doneDir = JobHistoryUtils.getConfiguredHistoryServerDoneDirPrefix((Configuration)conf);
            Path doneDirPath = fc.makeQualified(new Path(doneDir));
            fc.mkdir(doneDirPath, null, true);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Could not create staging directory. ", (Throwable)e);
        }
        conf.set("mapreduce.jobtracker.address", "test");
        String[] nmAuxServices = conf.getStrings("yarn.nodemanager.aux-services");
        boolean enableTimelineAuxService = false;
        if (nmAuxServices != null) {
            for (String nmAuxService : nmAuxServices) {
                if (!nmAuxService.equals(TIMELINE_AUX_SERVICE_NAME)) continue;
                enableTimelineAuxService = true;
                break;
            }
        }
        if (enableTimelineAuxService) {
            conf.setStrings("yarn.nodemanager.aux-services", new String[]{"mapreduce_shuffle", TIMELINE_AUX_SERVICE_NAME});
        } else {
            conf.setStrings("yarn.nodemanager.aux-services", new String[]{"mapreduce_shuffle"});
        }
        conf.setClass(String.format("yarn.nodemanager.aux-services.%s.class", "mapreduce_shuffle"), ShuffleHandler.class, Service.class);
        conf.setInt("mapreduce.shuffle.port", 0);
        conf.setClass("yarn.nodemanager.container-executor.class", DefaultContainerExecutor.class, ContainerExecutor.class);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        if (this.historyServer != null) {
            this.getConfig().set("mapreduce.jobhistory.address", this.historyServer.getConfig().get("mapreduce.jobhistory.address"));
            MRWebAppUtil.setJHSWebappURLWithoutScheme((Configuration)this.getConfig(), (String)MRWebAppUtil.getJHSWebappURLWithoutScheme((Configuration)this.historyServer.getConfig()));
        }
        LOG.info("MiniMRYARN ResourceManager address: " + this.getConfig().get("yarn.resourcemanager.address"));
        LOG.info("MiniMRYARN ResourceManager web address: " + WebAppUtils.getRMWebAppURLWithoutScheme((Configuration)this.getConfig()));
        LOG.info("MiniMRYARN HistoryServer address: " + this.getConfig().get("mapreduce.jobhistory.address"));
        LOG.info("MiniMRYARN HistoryServer web address: " + MiniMRYarnCluster.getResolvedMRHistoryWebAppURLWithoutScheme(this.getConfig(), MRWebAppUtil.getJHSHttpPolicy() == HttpConfig.Policy.HTTPS_ONLY));
    }

    public JobHistoryServer getHistoryServer() {
        return this.historyServer;
    }

    private class JobHistoryServerWrapper
    extends AbstractService {
        public JobHistoryServerWrapper() {
            super(JobHistoryServerWrapper.class.getName());
        }

        public synchronized void serviceStart() throws Exception {
            try {
                if (!this.getConfig().getBoolean("mapreduce.jobhistory.minicluster.fixed.ports", JHAdminConfig.DEFAULT_MR_HISTORY_MINICLUSTER_FIXED_PORTS)) {
                    String hostname = MiniYARNCluster.getHostname();
                    this.getConfig().set("mapreduce.jobhistory.address", hostname + ":0");
                    MRWebAppUtil.setJHSWebappURLWithoutScheme((Configuration)this.getConfig(), (String)(hostname + ":0"));
                    this.getConfig().set("mapreduce.jobhistory.admin.address", hostname + ":0");
                }
                MiniMRYarnCluster.this.historyServer = new JobHistoryServer();
                MiniMRYarnCluster.this.historyServer.init(this.getConfig());
                new Thread(){

                    @Override
                    public void run() {
                        MiniMRYarnCluster.this.historyServer.start();
                    }
                }.start();
                int launchTimeout = this.getConfig().getInt(MiniMRYarnCluster.MR_HISTORY_MINICLUSTER_LAUNCH_TIMEOUT_MS, 60000);
                GenericTestUtils.waitFor(() -> MiniMRYarnCluster.this.historyServer.getServiceState() == Service.STATE.STARTED || MiniMRYarnCluster.this.historyServer.getServiceState() == Service.STATE.STOPPED, (long)100L, (long)launchTimeout);
                if (MiniMRYarnCluster.this.historyServer.getServiceState() != Service.STATE.STARTED) {
                    throw new IOException("HistoryServer failed to start");
                }
                super.serviceStart();
            }
            catch (Throwable t) {
                throw new YarnRuntimeException(t);
            }
        }

        public synchronized void serviceStop() throws Exception {
            if (MiniMRYarnCluster.this.historyServer != null) {
                MiniMRYarnCluster.this.historyServer.stop();
            }
            super.serviceStop();
        }
    }
}

