/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Utils;
import org.junit.Assert;
import org.junit.Test;

public class TestUtils {
    private static final Path[] LOG_PATHS = new Path[]{new Path("file:///foo/_logs"), new Path("file:///foo/_logs/"), new Path("_logs/"), new Path("_logs")};
    private static final Path[] SUCCEEDED_PATHS = new Path[]{new Path("file:///blah/_SUCCESS")};
    private static final Path[] PASS_PATHS = new Path[]{new Path("file:///my_logs/blah"), new Path("file:///a/b/c"), new Path("file:///foo/_logs/blah"), new Path("_logs/foo"), new Path("file:///blah/_SUCCESS/bar")};

    @Test
    public void testOutputFilesFilter() {
        Utils.OutputFileUtils.OutputFilesFilter filter = new Utils.OutputFileUtils.OutputFilesFilter();
        for (Path p : LOG_PATHS) {
            Assert.assertFalse((boolean)filter.accept(p));
        }
        for (Path p : SUCCEEDED_PATHS) {
            Assert.assertFalse((boolean)filter.accept(p));
        }
        for (Path p : PASS_PATHS) {
            Assert.assertTrue((boolean)filter.accept(p));
        }
    }

    @Test
    public void testLogFilter() {
        Utils.OutputFileUtils.OutputLogFilter filter = new Utils.OutputFileUtils.OutputLogFilter();
        for (Path p : LOG_PATHS) {
            Assert.assertFalse((boolean)filter.accept(p));
        }
        for (Path p : SUCCEEDED_PATHS) {
            Assert.assertTrue((boolean)filter.accept(p));
        }
        for (Path p : PASS_PATHS) {
            Assert.assertTrue((boolean)filter.accept(p));
        }
    }
}

