/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

class Helper {
    private static final String[] emptyStringArray = new String[0];

    private Helper() {
    }

    static String[] getTrimmedStrings(String str) {
        if (null == str || "".equals(str.trim())) {
            return emptyStringArray;
        }
        return str.trim().split("\\s*,\\s*");
    }

    static String toByteInfo(long bytes) {
        StringBuilder str = new StringBuilder();
        if (bytes < 0L) {
            bytes = 0L;
        }
        str.append(bytes);
        str.append(" bytes or ");
        str.append(bytes / 1024L);
        str.append(" kilobytes or ");
        str.append(bytes / 0x100000L);
        str.append(" megabytes or ");
        str.append(bytes / 0x40000000L);
        str.append(" gigabytes");
        return str.toString();
    }

    static String stringifyArray(Object[] args, String sep) {
        StringBuilder optStr = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            optStr.append(args[i]);
            if (i + 1 == args.length) continue;
            optStr.append(sep);
        }
        return optStr.toString();
    }
}

