/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider.example;

import java.util.Collection;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.provider.BuiltInProviderSelector;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.example.ShadeSaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ShadeProviderSelector
extends BuiltInProviderSelector {
    private final Text SHADE_TOKEN_KIND_TEXT = new Text("HBASE_EXAMPLE_SHADE_TOKEN");
    private ShadeSaslClientAuthenticationProvider shade;

    public void configure(Configuration conf, Collection<SaslClientAuthenticationProvider> providers) {
        super.configure(conf, providers);
        this.shade = (ShadeSaslClientAuthenticationProvider)providers.stream().filter(p -> p instanceof ShadeSaslClientAuthenticationProvider).findFirst().orElseThrow(() -> new RuntimeException("ShadeSaslClientAuthenticationProvider not loaded"));
    }

    public Pair<SaslClientAuthenticationProvider, Token<? extends TokenIdentifier>> selectProvider(String clusterId, User user) {
        Pair pair = super.selectProvider(clusterId, user);
        Optional<Token> optional = user.getTokens().stream().filter(t -> this.SHADE_TOKEN_KIND_TEXT.equals((Object)t.getKind())).findFirst();
        if (optional.isPresent()) {
            return new Pair((Object)this.shade, (Object)optional.get());
        }
        return pair;
    }
}

