/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProperties {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationProperties.class);
    private final Map<String, PrefixNode> nodes = new HashMap<String, PrefixNode>();
    private static final String DELIMITER = "\\.";

    public ConfigurationProperties(Map<String, String> props) {
        this.storePropertiesInPrefixNodes(props);
    }

    public Map<String, String> getPropertiesWithPrefix(String prefix) {
        return this.getPropertiesWithPrefix(prefix, false);
    }

    public Map<String, String> getPropertiesWithPrefix(String prefix, boolean fullyQualifiedKey) {
        List<String> propertyPrefixParts = this.splitPropertyByDelimiter(prefix);
        HashMap<String, String> properties = new HashMap<String, String>();
        String trimPrefix = fullyQualifiedKey ? "" : (prefix.endsWith(".") ? prefix.substring(0, prefix.length() - 1) : prefix);
        this.collectPropertiesRecursively(this.nodes, properties, propertyPrefixParts.iterator(), trimPrefix);
        return properties;
    }

    private void collectPropertiesRecursively(Map<String, PrefixNode> childNodes, Map<String, String> properties, Iterator<String> prefixParts, String trimPrefix) {
        if (prefixParts.hasNext()) {
            String prefix = prefixParts.next();
            PrefixNode candidate = childNodes.get(prefix);
            if (candidate != null) {
                if (!prefixParts.hasNext()) {
                    this.copyProperties(properties, trimPrefix, candidate.getValues());
                }
                this.collectPropertiesRecursively(candidate.getChildren(), properties, prefixParts, trimPrefix);
            }
        } else {
            for (Map.Entry<String, PrefixNode> child : childNodes.entrySet()) {
                this.copyProperties(properties, trimPrefix, child.getValue().getValues());
                this.collectPropertiesRecursively(child.getValue().getChildren(), properties, prefixParts, trimPrefix);
            }
        }
    }

    private void copyProperties(Map<String, String> copyTo, String trimPrefix, Map<String, String> copyFrom) {
        for (Map.Entry<String, String> configEntry : copyFrom.entrySet()) {
            String key = configEntry.getKey();
            String prefixToTrim = trimPrefix;
            if (!trimPrefix.isEmpty()) {
                if (!key.equals(trimPrefix)) {
                    prefixToTrim = prefixToTrim + ".";
                }
                key = configEntry.getKey().substring(prefixToTrim.length());
            }
            copyTo.put(key, configEntry.getValue());
        }
    }

    private void storePropertiesInPrefixNodes(Map<String, String> props) {
        for (Map.Entry<String, String> prop : props.entrySet()) {
            List<String> propertyKeyParts = this.splitPropertyByDelimiter(prop.getKey());
            if (!propertyKeyParts.isEmpty()) {
                PrefixNode node = this.findOrCreatePrefixNode(this.nodes, propertyKeyParts.iterator());
                node.getValues().put(prop.getKey(), prop.getValue());
                continue;
            }
            LOG.warn("Empty configuration property, skipping...");
        }
    }

    private PrefixNode findOrCreatePrefixNode(Map<String, PrefixNode> children, Iterator<String> propertyKeyParts) {
        String prefix = propertyKeyParts.next();
        PrefixNode candidate = children.get(prefix);
        if (candidate == null) {
            candidate = new PrefixNode();
            children.put(prefix, candidate);
        }
        if (!propertyKeyParts.hasNext()) {
            return candidate;
        }
        return this.findOrCreatePrefixNode(candidate.getChildren(), propertyKeyParts);
    }

    private List<String> splitPropertyByDelimiter(String property) {
        return Arrays.asList(property.split(DELIMITER));
    }

    private static class PrefixNode {
        private final Map<String, String> values = new HashMap<String, String>();
        private final Map<String, PrefixNode> children = new HashMap<String, PrefixNode>();

        PrefixNode() {
        }

        public Map<String, String> getValues() {
            return this.values;
        }

        public Map<String, PrefixNode> getChildren() {
            return this.children;
        }
    }
}

