/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Option;

public abstract class ProcedureStorePerformanceEvaluation<T extends ProcedureStore>
extends AbstractHBaseTool {
    public static String DEFAULT_OUTPUT_PATH = "proc-store";
    public static Option OUTPUT_PATH_OPTION = new Option("output", true, "The output path. Default: " + DEFAULT_OUTPUT_PATH);
    public static int DEFAULT_NUM_THREADS = 20;
    public static Option NUM_THREADS_OPTION = new Option("threads", true, "Number of parallel threads which will write insert/updates/deletes to store. Default: " + DEFAULT_NUM_THREADS);
    public static int DEFAULT_NUM_PROCS = 1000000;
    public static Option NUM_PROCS_OPTION = new Option("procs", true, "Total number of procedures. Each procedure writes one insert and one update. Default: " + DEFAULT_NUM_PROCS);
    public static int DEFAULT_STATE_SIZE = 1024;
    public static Option STATE_SIZE_OPTION = new Option("state_size", true, "Size of serialized state in bytes to write on update. Default: " + DEFAULT_STATE_SIZE + "bytes");
    public static Option SYNC_OPTION = new Option("sync", true, "Type of sync to use when writing WAL contents to file system. Accepted values: hflush, hsync, nosync. Default: hflush");
    public static String DEFAULT_SYNC_OPTION = "hflush";
    protected String outputPath;
    protected int numThreads;
    protected long numProcs;
    protected String syncType;
    protected int stateSize;
    protected static byte[] SERIALIZED_STATE;
    protected T store;
    private AtomicLong procIds = new AtomicLong(0L);
    private AtomicBoolean workersFailed = new AtomicBoolean(false);
    private static final int WORKER_THREADS_TIMEOUT_SEC = 600;

    protected void addOptions() {
        this.addOption(OUTPUT_PATH_OPTION);
        this.addOption(NUM_THREADS_OPTION);
        this.addOption(NUM_PROCS_OPTION);
        this.addOption(SYNC_OPTION);
        this.addOption(STATE_SIZE_OPTION);
    }

    protected void processOptions(CommandLine cmd) {
        this.outputPath = cmd.getOptionValue(OUTPUT_PATH_OPTION.getOpt(), DEFAULT_OUTPUT_PATH);
        this.numThreads = this.getOptionAsInt(cmd, NUM_THREADS_OPTION.getOpt(), DEFAULT_NUM_THREADS);
        this.numProcs = this.getOptionAsInt(cmd, NUM_PROCS_OPTION.getOpt(), DEFAULT_NUM_PROCS);
        this.syncType = cmd.getOptionValue(SYNC_OPTION.getOpt(), DEFAULT_SYNC_OPTION);
        assert ("hsync".equals(this.syncType) || "hflush".equals(this.syncType) || "nosync".equals(this.syncType)) : "sync argument can only accept one of these three values: hsync, hflush, nosync";
        this.stateSize = this.getOptionAsInt(cmd, STATE_SIZE_OPTION.getOpt(), DEFAULT_STATE_SIZE);
        SERIALIZED_STATE = new byte[this.stateSize];
        Bytes.random((byte[])SERIALIZED_STATE);
    }

    private void setUpProcedureStore() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path storeDir = fs.makeQualified(new Path(this.outputPath));
        System.out.println("Procedure store directory : " + storeDir.toString());
        fs.delete(storeDir, true);
        this.store = this.createProcedureStore(storeDir);
        this.store.start(this.numThreads);
        this.store.recoverLease();
        this.store.load((ProcedureStore.ProcedureLoader)new ProcedureTestingUtility.LoadCounter());
        System.out.println("Starting new procedure store: " + this.store.getClass().getSimpleName());
    }

    protected abstract T createProcedureStore(Path var1) throws IOException;

    protected void postStop(T store) throws IOException {
    }

    private void tearDownProcedureStore() {
        Path storeDir = null;
        try {
            if (this.store != null) {
                this.store.stop(false);
                this.postStop(this.store);
            }
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            storeDir = fs.makeQualified(new Path(this.outputPath));
            fs.delete(storeDir, true);
        }
        catch (IOException e) {
            System.err.println("Error: Couldn't delete log dir. You can delete it manually to free up disk space. Location: " + storeDir);
            e.printStackTrace();
        }
    }

    protected abstract void printRawFormatResult(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doWork() throws Exception {
        try {
            this.setUpProcedureStore();
            ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
            Future[] futures = new Future[this.numThreads];
            long start = System.nanoTime();
            for (int i = 0; i < this.numThreads; ++i) {
                futures[i] = executor.submit(new Worker(start));
            }
            boolean failure = false;
            try {
                for (Future future : futures) {
                    long timeout = start + 600000L - EnvironmentEdgeManager.currentTime();
                    failure |= future.get(timeout, TimeUnit.MILLISECONDS).equals(1);
                }
            }
            catch (Exception e) {
                System.err.println("Exception in worker thread.");
                e.printStackTrace();
                int n = 1;
                this.tearDownProcedureStore();
                return n;
            }
            executor.shutdown();
            if (failure) {
                int e = 1;
                return e;
            }
            long timeTakenNs = System.nanoTime() - start;
            System.out.println("******************************************");
            System.out.println("Num threads    : " + this.numThreads);
            System.out.println("Num procedures : " + this.numProcs);
            System.out.println("Sync type      : " + this.syncType);
            System.out.println("Time taken     : " + TimeUnit.NANOSECONDS.toSeconds(timeTakenNs) + "sec");
            System.out.println("******************************************");
            System.out.println("Raw format for scripts");
            this.printRawFormatResult(timeTakenNs);
            int n = 0;
            return n;
        }
        catch (IOException e) {
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            this.tearDownProcedureStore();
        }
    }

    protected abstract void preWrite(long var1) throws IOException;

    private final class Worker
    implements Callable<Integer> {
        private final long start;

        public Worker(long start) {
            this.start = start;
        }

        @Override
        public Integer call() throws IOException {
            while (true) {
                if (ProcedureStorePerformanceEvaluation.this.workersFailed.get()) {
                    return 1;
                }
                long procId = ProcedureStorePerformanceEvaluation.this.procIds.getAndIncrement();
                if (procId >= ProcedureStorePerformanceEvaluation.this.numProcs) break;
                if (procId != 0L && procId % 10000L == 0L) {
                    long ns = System.nanoTime() - this.start;
                    System.out.println("Wrote " + procId + " procedures in " + StringUtils.humanTimeDiff((long)TimeUnit.NANOSECONDS.toMillis(ns)));
                }
                try {
                    ProcedureStorePerformanceEvaluation.this.preWrite(procId);
                }
                catch (IOException ioe) {
                    ProcedureStorePerformanceEvaluation.this.workersFailed.set(true);
                    System.err.println("Exception when rolling log file. Current procId = " + procId);
                    ioe.printStackTrace();
                    return 1;
                }
                ProcedureTestingUtility.TestProcedure proc = new ProcedureTestingUtility.TestProcedure(procId);
                proc.setData(SERIALIZED_STATE);
                ProcedureStorePerformanceEvaluation.this.store.insert((Procedure)proc, null);
                ProcedureStorePerformanceEvaluation.this.store.update((Procedure)proc);
            }
            return 0;
        }
    }
}

