/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ZKTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.RegionServerAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.zookeeper.KeeperException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ZKTests.class, MediumTests.class})
public class TestRegionServerAddressTracker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerAddressTracker.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionServerAddressTracker.class);
    private static final HBaseZKTestingUtility TEST_UTIL = new HBaseZKTestingUtility();
    private ZKWatcher zk;
    private RegionServerAddressTracker tracker;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Before
    public void setUp() throws ZooKeeperConnectionException, IOException, KeeperException {
        TEST_UTIL.getConfiguration().set("zookeeper.znode.parent", "/" + this.name.getMethodName());
        this.zk = new ZKWatcher(TEST_UTIL.getConfiguration(), this.name.getMethodName(), null);
        ZKUtil.createWithParents((ZKWatcher)this.zk, (String)this.zk.getZNodePaths().rsZNode);
        this.tracker = new RegionServerAddressTracker(this.zk, (Abortable)new WarnOnlyAbortable());
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.zk, (boolean)true);
    }

    @Test
    public void test() throws KeeperException {
        ServerName rs1 = ServerName.valueOf((String)"127.0.0.1", (int)16000, (long)EnvironmentEdgeManager.currentTime());
        ZKUtil.createWithParents((ZKWatcher)this.zk, (String)ZNodePaths.joinZNode((String)this.zk.getZNodePaths().rsZNode, (String)rs1.toString()));
        TEST_UTIL.waitFor(10000L, () -> this.tracker.getRegionServers().size() == 1);
        Assert.assertEquals((Object)rs1, this.tracker.getRegionServers().get(0));
        ServerName rs2 = ServerName.valueOf((String)"127.0.0.2", (int)16000, (long)EnvironmentEdgeManager.currentTime());
        ZKUtil.createWithParents((ZKWatcher)this.zk, (String)ZNodePaths.joinZNode((String)this.zk.getZNodePaths().rsZNode, (String)rs2.toString()));
        TEST_UTIL.waitFor(10000L, () -> this.tracker.getRegionServers().size() == 2);
        MatcherAssert.assertThat((Object)this.tracker.getRegionServers(), (Matcher)CoreMatchers.hasItems((Object[])new ServerName[]{rs1, rs2}));
        ZKUtil.deleteNode((ZKWatcher)this.zk, (String)ZNodePaths.joinZNode((String)this.zk.getZNodePaths().rsZNode, (String)rs1.toString()));
        TEST_UTIL.waitFor(10000L, () -> this.tracker.getRegionServers().size() == 1);
        Assert.assertEquals((Object)rs2, this.tracker.getRegionServers().get(0));
        ZKUtil.deleteNode((ZKWatcher)this.zk, (String)ZNodePaths.joinZNode((String)this.zk.getZNodePaths().rsZNode, (String)rs2.toString()));
        TEST_UTIL.waitFor(10000L, () -> this.tracker.getRegionServers().isEmpty());
    }

    private static final class WarnOnlyAbortable
    implements Abortable {
        private WarnOnlyAbortable() {
        }

        public void abort(String why, Throwable e) {
            LOG.warn("RegionServerAddressTracker received abort, ignoring.  Reason: {}", (Object)why, (Object)e);
        }

        public boolean isAborted() {
            return false;
        }
    }
}

