/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

public final class EnvironmentEdgeManagerTestHelper {
    private EnvironmentEdgeManagerTestHelper() {
    }

    public static void reset() {
        EnvironmentEdgeManager.reset();
    }

    public static void injectEdge(EnvironmentEdge edge) {
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
    }

    public static void injectEdgeForPackage(EnvironmentEdge edge, String packageName) {
        EnvironmentEdgeManagerTestHelper.injectEdge(new PackageEnvironmentEdgeWrapper(edge, packageName));
    }

    private static final class PackageEnvironmentEdgeWrapper
    implements EnvironmentEdge {
        private final EnvironmentEdge delegate;
        private final String packageName;

        PackageEnvironmentEdgeWrapper(EnvironmentEdge delegate, String packageName) {
            this.delegate = delegate;
            this.packageName = packageName;
        }

        public long currentTime() {
            StackTraceElement[] elements = new Exception().getStackTrace();
            if (elements.length > 2 && elements[2].getClassName().startsWith(this.packageName)) {
                return this.delegate.currentTime();
            }
            return System.currentTimeMillis();
        }
    }
}

