/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.locks.Lock;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.procedure2.BaseRSProcedureCallable;
import org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SplitWALCallable
extends BaseRSProcedureCallable {
    private String walPath;
    private final KeyLocker<String> splitWALLocks = new KeyLocker();
    private volatile Lock splitWALLock = null;

    @Override
    protected void initParameter(byte[] parameter) throws InvalidProtocolBufferException {
        MasterProcedureProtos.SplitWALParameter param = MasterProcedureProtos.SplitWALParameter.parseFrom((byte[])parameter);
        this.walPath = param.getWalPath();
    }

    @Override
    public EventType getEventType() {
        return EventType.RS_LOG_REPLAY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doCall() throws Exception {
        this.splitWALLock = this.splitWALLocks.acquireLock((Object)this.walPath);
        try {
            switch (SplitLogWorker.splitLog(this.walPath, null, this.rs.getConfiguration(), this.rs, this.rs, this.rs.getWalFactory())) {
                case DONE: {
                    return;
                }
                case PREEMPTED: {
                    throw new PreemptedWALSplitException(this.walPath);
                }
                case RESIGNED: {
                    throw new ResignedWALSplitException(this.walPath);
                }
                default: {
                    throw new ErrorWALSplitException(this.walPath);
                }
            }
        }
        finally {
            this.splitWALLock.unlock();
        }
    }

    public String getWalPath() {
        return this.walPath;
    }

    public static class ErrorWALSplitException
    extends HBaseIOException {
        ErrorWALSplitException(String wal) {
            super(wal);
        }
    }

    public static class ResignedWALSplitException
    extends HBaseIOException {
        ResignedWALSplitException(String wal) {
            super(wal);
        }
    }

    public static class PreemptedWALSplitException
    extends HBaseIOException {
        PreemptedWALSplitException(String wal) {
            super(wal);
        }
    }
}

