/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWAL;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSourceImpl;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MiscTests.class, SmallTests.class})
public class TestMetricsWAL {
    @Rule
    public TestName name = new TestName();
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsWAL.class);

    @Test
    public void testLogRollRequested() throws Exception {
        MetricsWALSource source = (MetricsWALSource)Mockito.mock(MetricsWALSourceImpl.class);
        MetricsWAL metricsWAL = new MetricsWAL(source);
        metricsWAL.logRollRequested(WALActionsListener.RollRequestReason.ERROR);
        metricsWAL.logRollRequested(WALActionsListener.RollRequestReason.LOW_REPLICATION);
        metricsWAL.logRollRequested(WALActionsListener.RollRequestReason.SLOW_SYNC);
        metricsWAL.logRollRequested(WALActionsListener.RollRequestReason.SIZE);
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)4))).incrementLogRollRequested();
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementErrorLogRoll();
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementLowReplicationLogRoll();
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementSlowSyncLogRoll();
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementSizeLogRoll();
    }

    @Test
    public void testPostSync() throws Exception {
        long nanos = TimeUnit.MILLISECONDS.toNanos(145L);
        MetricsWALSource source = (MetricsWALSource)Mockito.mock(MetricsWALSourceImpl.class);
        MetricsWAL metricsWAL = new MetricsWAL(source);
        metricsWAL.postSync(nanos, 1);
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementSyncTime(145L);
    }

    @Test
    public void testSlowAppend() throws Exception {
        String testName = this.name.getMethodName();
        MetricsWALSourceImpl source = new MetricsWALSourceImpl(testName, testName, testName, testName);
        MetricsWAL metricsWAL = new MetricsWAL((MetricsWALSource)source);
        TableName tableName = TableName.valueOf((String)"foo");
        WALKeyImpl walKey = new WALKeyImpl(null, tableName, -1L);
        metricsWAL.postAppend(1L, 900L, (WALKey)walKey, null);
        metricsWAL.postAppend(1L, 1010L, (WALKey)walKey, null);
        metricsWAL.postAppend(1L, 2000L, (WALKey)walKey, null);
        Assert.assertEquals((long)2L, (long)source.getSlowAppendCount());
    }

    @Test
    public void testWalWrittenInBytes() throws Exception {
        MetricsWALSource source = (MetricsWALSource)Mockito.mock(MetricsWALSourceImpl.class);
        MetricsWAL metricsWAL = new MetricsWAL(source);
        TableName tableName = TableName.valueOf((String)"foo");
        WALKeyImpl walKey = new WALKeyImpl(null, tableName, -1L);
        metricsWAL.postAppend(100L, 900L, (WALKey)walKey, null);
        metricsWAL.postAppend(200L, 2000L, (WALKey)walKey, null);
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementWrittenBytes(100L);
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementWrittenBytes(200L);
    }

    @Test
    public void testPerTableWALMetrics() throws Exception {
        MetricsWALSourceImpl source = new MetricsWALSourceImpl("foo", "foo", "foo", "foo");
        int numThreads = 10;
        int numIters = 10;
        CountDownLatch latch = new CountDownLatch(10);
        for (int i = 0; i < 10; ++i) {
            TableName tableName = TableName.valueOf((String)("tab_" + i));
            long size = i;
            new Thread(() -> {
                for (int j = 0; j < 10; ++j) {
                    source.incrementAppendCount(tableName);
                    source.incrementAppendSize(tableName, size);
                }
                latch.countDown();
            }).start();
        }
        latch.await();
        DynamicMetricsRegistry registry = source.getMetricsRegistry();
        for (int i = 0; i < 10; ++i) {
            TableName tableName = TableName.valueOf((String)("tab_" + i));
            long tableAppendCount = registry.getCounter(tableName + "." + "appendCount", -1L).value();
            Assert.assertEquals((long)10L, (long)tableAppendCount);
            long tableAppendSize = registry.getCounter(tableName + "." + "appendSize", -1L).value();
            Assert.assertEquals((long)(i * 10), (long)tableAppendSize);
        }
    }

    @Test
    public void testLogRolls() {
        String testName = this.name.getMethodName();
        MetricsWALSourceImpl source = new MetricsWALSourceImpl(testName, testName, testName, testName);
        MetricsWAL metricsWAL = new MetricsWAL((MetricsWALSource)source);
        Path path1 = new Path("path-1");
        int count = 1;
        metricsWAL.postLogRoll(null, path1);
        Assert.assertEquals((long)count, (long)source.getSuccessfulLogRolls());
        metricsWAL.postLogRoll(path1, path1);
        Assert.assertEquals((long)count, (long)source.getSuccessfulLogRolls());
        Path path2 = new Path("path-2");
        metricsWAL.postLogRoll(path1, path2);
        Assert.assertEquals((long)(++count), (long)source.getSuccessfulLogRolls());
    }
}

