/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.http.gson;

import java.util.TreeMap;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.master.http.gson.GsonFactory;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class GsonFactoryTest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(GsonFactoryTest.class);
    private static Gson gson;

    @BeforeClass
    public static void beforeClass() {
        gson = GsonFactory.buildGson();
    }

    @Test
    public void testSerializeToLowerCaseUnderscores() {
        SomeBean input = new SomeBean(false, 57, "hello\n");
        String actual = gson.toJson((Object)input);
        String expected = "{\"a_boolean\":false,\"an_int\":57,\"a_string\":\"hello\\n\"}";
        Assert.assertEquals((Object)"{\"a_boolean\":false,\"an_int\":57,\"a_string\":\"hello\\n\"}", (Object)actual);
    }

    @Test
    public void testSerializeMapWithSizeKeys() {
        TreeMap<Size, String> input = new TreeMap<Size, String>();
        input.put(new Size(10.0, Size.Unit.KILOBYTE), "10kb");
        input.put(new Size(5.0, Size.Unit.MEGABYTE), "5mb");
        String actual = gson.toJson(input);
        String expected = "{\"10240.0\":\"10kb\",\"5242880.0\":\"5mb\"}";
        Assert.assertEquals((Object)"{\"10240.0\":\"10kb\",\"5242880.0\":\"5mb\"}", (Object)actual);
    }

    @Test
    public void testSerializeNonPrintableByteArrays() {
        TreeMap<byte[], byte[]> input = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
        input.put(Bytes.toBytes((String)"this is printable"), new byte[]{0, 1, 2, 3, 4, 5});
        input.put(new byte[]{-127, -63, 0, 63, 127}, Bytes.toBytes((String)"test"));
        String actual = gson.toJson(input);
        String expected = "{\"this is printable\":\"\\u0000\\u0001\\u0002\\u0003\\u0004\\u0005\",\"\ufffd\ufffd\\u0000?\u007f\":\"test\"}";
        Assert.assertEquals((Object)"{\"this is printable\":\"\\u0000\\u0001\\u0002\\u0003\\u0004\\u0005\",\"\ufffd\ufffd\\u0000?\u007f\":\"test\"}", (Object)actual);
    }

    private static final class SomeBean {
        private final boolean aBoolean;
        private final int anInt;
        private final String aString;

        public SomeBean(boolean aBoolean, int anInt, String aString) {
            this.aBoolean = aBoolean;
            this.anInt = anInt;
            this.aString = aString;
        }

        public boolean isaBoolean() {
            return this.aBoolean;
        }

        public int getAnInt() {
            return this.anInt;
        }

        public String getaString() {
            return this.aString;
        }
    }
}

