/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.coprocessor.BaseEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ClassLoaderTestHelper;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCoprocessorHost {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCoprocessorHost.class);
    private static final HBaseCommonTestingUtility TEST_UTIL = new HBaseCommonTestingUtility();

    @Test
    public void testDoubleLoadingAndPriorityValue() {
        Configuration conf = HBaseConfiguration.create();
        String key = "KEY";
        String coprocessor = "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver";
        CoprocessorHostForTest host = new CoprocessorHostForTest(conf);
        int overridePriority = 0x7FFFFFFE;
        String coprocessor_v3 = SimpleRegionObserverV3.class.getName() + "|" + overridePriority;
        conf.setStrings("KEY", new String[]{"org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver", "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver", "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver", SimpleRegionObserverV2.class.getName(), coprocessor_v3});
        host.loadSystemCoprocessors(conf, "KEY");
        Assert.assertEquals((long)3L, (long)host.coprocEnvironments.size());
        CoprocessorEnvironment simpleEnv = host.findCoprocessorEnvironment(SimpleRegionObserver.class.getName());
        CoprocessorEnvironment simpleEnv_v2 = host.findCoprocessorEnvironment(SimpleRegionObserverV2.class.getName());
        CoprocessorEnvironment simpleEnv_v3 = host.findCoprocessorEnvironment(SimpleRegionObserverV3.class.getName());
        Assert.assertNotNull((Object)simpleEnv);
        Assert.assertNotNull((Object)simpleEnv_v2);
        Assert.assertNotNull((Object)simpleEnv_v3);
        Assert.assertEquals((long)0x1FFFFFFFL, (long)simpleEnv.getPriority());
        Assert.assertEquals((long)0x20000000L, (long)simpleEnv_v2.getPriority());
        Assert.assertEquals((long)overridePriority, (long)simpleEnv_v3.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadSystemCoprocessorWithPath() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        String key = "KEY";
        String testClassName = "TestSystemCoprocessor";
        String testClassNameWithPriorityAndPath = "TestSystemCoprocessorPriorityAndPath";
        File jarFile = this.buildCoprocessorJar("TestSystemCoprocessor");
        File jarFileWithPriorityAndPath = this.buildCoprocessorJar("TestSystemCoprocessorPriorityAndPath");
        try {
            CoprocessorHostForTest host = new CoprocessorHostForTest(conf);
            int overridePriority = 0x7FFFFFFE;
            String coprocessorWithPriority = SimpleRegionObserverV3.class.getName() + "|" + overridePriority;
            String coprocessorWithPath = String.format("%s|%s|%s", "TestSystemCoprocessor", "", jarFile.getAbsolutePath());
            String coprocessorWithPriorityAndPath = String.format("%s|%s|%s", "TestSystemCoprocessorPriorityAndPath", overridePriority - 1, jarFileWithPriorityAndPath.getAbsolutePath());
            conf.setStrings("KEY", new String[]{SimpleRegionObserverV2.class.getName(), coprocessorWithPriority, coprocessorWithPath, coprocessorWithPriorityAndPath});
            host.loadSystemCoprocessors(conf, "KEY");
            CoprocessorEnvironment simpleEnv = host.findCoprocessorEnvironment(SimpleRegionObserverV2.class.getName());
            Assert.assertNotNull((Object)simpleEnv);
            Assert.assertEquals((long)0x1FFFFFFFL, (long)simpleEnv.getPriority());
            CoprocessorEnvironment coprocessorEnvironmentWithPath = host.findCoprocessorEnvironment("TestSystemCoprocessor");
            Assert.assertNotNull((Object)coprocessorEnvironmentWithPath);
            Assert.assertEquals((long)0x20000000L, (long)coprocessorEnvironmentWithPath.getPriority());
            CoprocessorEnvironment coprocessorEnvironmentWithPriority = host.findCoprocessorEnvironment(SimpleRegionObserverV3.class.getName());
            Assert.assertNotNull((Object)coprocessorEnvironmentWithPriority);
            Assert.assertEquals((long)overridePriority, (long)coprocessorEnvironmentWithPriority.getPriority());
            CoprocessorEnvironment coprocessorEnvironmentWithPriorityAndPath = host.findCoprocessorEnvironment("TestSystemCoprocessorPriorityAndPath");
            Assert.assertNotNull((Object)coprocessorEnvironmentWithPriorityAndPath);
            Assert.assertEquals((long)(overridePriority - 1), (long)coprocessorEnvironmentWithPriorityAndPath.getPriority());
        }
        finally {
            if (jarFile.exists()) {
                jarFile.delete();
            }
            if (jarFileWithPriorityAndPath.exists()) {
                jarFileWithPriorityAndPath.delete();
            }
        }
    }

    @Test(expected=AssertionError.class)
    public void testLoadSystemCoprocessorWithPathDoesNotExist() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        String key = "KEY";
        String testClassName = "TestSystemCoprocessor";
        CoprocessorHostForTest host = new CoprocessorHostForTest(conf);
        String coprocessorWithPath = "TestSystemCoprocessor||TestSystemCoprocessor.jar";
        conf.setStrings("KEY", new String[]{"TestSystemCoprocessor||TestSystemCoprocessor.jar"});
        host.loadSystemCoprocessors(conf, "KEY");
    }

    @Test(expected=AssertionError.class)
    public void testLoadSystemCoprocessorWithPathDoesNotExistAndPriority() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        String key = "KEY";
        String testClassName = "TestSystemCoprocessor";
        CoprocessorHostForTest host = new CoprocessorHostForTest(conf);
        int overridePriority = 0x7FFFFFFE;
        String coprocessor = "TestSystemCoprocessor|" + overridePriority + "|" + "TestSystemCoprocessor" + ".jar";
        conf.setStrings("KEY", new String[]{coprocessor});
        host.loadSystemCoprocessors(conf, "KEY");
    }

    private File buildCoprocessorJar(String className) throws Exception {
        String dataTestDir = TEST_UTIL.getDataTestDir().toString();
        String code = String.format("import org.apache.hadoop.hbase.coprocessor.*; public class %s implements RegionCoprocessor {}", className);
        return ClassLoaderTestHelper.buildJar((String)dataTestDir, (String)className, (String)code);
    }

    private static class CoprocessorHostForTest<E extends Coprocessor>
    extends CoprocessorHost<E, CoprocessorEnvironment<E>> {
        final Configuration cpHostConf;

        public CoprocessorHostForTest(Configuration conf) {
            super((Abortable)new TestAbortable());
            this.cpHostConf = conf;
        }

        public E checkAndGetInstance(Class<?> implClass) throws InstantiationException, IllegalAccessException {
            try {
                return (E)((Coprocessor)implClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                throw (InstantiationException)new InstantiationException().initCause(e);
            }
        }

        public CoprocessorEnvironment<E> createEnvironment(E instance, int priority, int sequence, Configuration conf) {
            return new BaseEnvironment(instance, priority, 0, this.cpHostConf);
        }
    }

    public static class SimpleRegionObserverV3
    extends SimpleRegionObserver {
    }

    public static class SimpleRegionObserverV2
    extends SimpleRegionObserver {
    }

    private static class TestAbortable
    implements Abortable {
        private volatile boolean aborted = false;

        private TestAbortable() {
        }

        public void abort(String why, Throwable e) {
            this.aborted = true;
            Assert.fail((String)e.getMessage());
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }
}

