/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SchemaManager;

public class DnNormalizer
extends Normalizer {
    private SchemaManager schemaManager;

    public DnNormalizer() {
        super("2.5.13.1");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        Dn dn = null;
        String dnStr = value.getString();
        dn = new Dn(this.schemaManager, dnStr);
        return new StringValue(dn.getNormName());
    }

    @Override
    public String normalize(String value) throws LdapException {
        Dn dn = null;
        dn = new Dn(this.schemaManager, value);
        return dn.getNormName();
    }

    public String normalize(Dn value) throws LdapException {
        Dn dn = null;
        dn = value.apply(this.schemaManager);
        return dn.getNormName();
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

