/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.records.impl.pb;

import com.google.common.base.Preconditions;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.federation.proto.YarnServerFederationProtos;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterIdPBImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SubClusterInfoPBImpl
extends SubClusterInfo {
    private YarnServerFederationProtos.SubClusterInfoProto proto = YarnServerFederationProtos.SubClusterInfoProto.getDefaultInstance();
    private YarnServerFederationProtos.SubClusterInfoProto.Builder builder = null;
    private boolean viaProto = false;
    private SubClusterId subClusterId = null;

    public SubClusterInfoPBImpl() {
        this.builder = YarnServerFederationProtos.SubClusterInfoProto.newBuilder();
    }

    public SubClusterInfoPBImpl(YarnServerFederationProtos.SubClusterInfoProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerFederationProtos.SubClusterInfoProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerFederationProtos.SubClusterInfoProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToBuilder() {
        if (this.subClusterId != null) {
            this.builder.setSubClusterId(this.convertToProtoFormat(this.subClusterId));
        }
    }

    @Override
    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    @Override
    public SubClusterId getSubClusterId() {
        YarnServerFederationProtos.SubClusterInfoProtoOrBuilder p;
        YarnServerFederationProtos.SubClusterInfoProtoOrBuilder subClusterInfoProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.subClusterId != null) {
            return this.subClusterId;
        }
        if (!p.hasSubClusterId()) {
            return null;
        }
        this.subClusterId = this.convertFromProtoFormat(p.getSubClusterId());
        return this.subClusterId;
    }

    @Override
    public void setSubClusterId(SubClusterId subClusterId) {
        this.maybeInitBuilder();
        if (subClusterId == null) {
            this.builder.clearSubClusterId();
        }
        this.subClusterId = subClusterId;
    }

    @Override
    public String getAMRMServiceAddress() {
        YarnServerFederationProtos.SubClusterInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasAMRMServiceAddress() ? p.getAMRMServiceAddress() : null;
    }

    @Override
    public void setAMRMServiceAddress(String amRMServiceAddress) {
        this.maybeInitBuilder();
        if (amRMServiceAddress == null) {
            this.builder.clearAMRMServiceAddress();
            return;
        }
        this.builder.setAMRMServiceAddress(amRMServiceAddress);
    }

    @Override
    public String getClientRMServiceAddress() {
        YarnServerFederationProtos.SubClusterInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasClientRMServiceAddress() ? p.getClientRMServiceAddress() : null;
    }

    @Override
    public void setClientRMServiceAddress(String clientRMServiceAddress) {
        this.maybeInitBuilder();
        if (clientRMServiceAddress == null) {
            this.builder.clearClientRMServiceAddress();
            return;
        }
        this.builder.setClientRMServiceAddress(clientRMServiceAddress);
    }

    @Override
    public String getRMAdminServiceAddress() {
        YarnServerFederationProtos.SubClusterInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasRMAdminServiceAddress() ? p.getRMAdminServiceAddress() : null;
    }

    @Override
    public void setRMAdminServiceAddress(String rmAdminServiceAddress) {
        this.maybeInitBuilder();
        if (rmAdminServiceAddress == null) {
            this.builder.clearRMAdminServiceAddress();
            return;
        }
        this.builder.setRMAdminServiceAddress(rmAdminServiceAddress);
    }

    @Override
    public String getRMWebServiceAddress() {
        YarnServerFederationProtos.SubClusterInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasRMWebServiceAddress() ? p.getRMWebServiceAddress() : null;
    }

    @Override
    public void setRMWebServiceAddress(String rmWebServiceAddress) {
        this.maybeInitBuilder();
        if (rmWebServiceAddress == null) {
            this.builder.clearRMWebServiceAddress();
            return;
        }
        this.builder.setRMWebServiceAddress(rmWebServiceAddress);
    }

    @Override
    public long getLastHeartBeat() {
        YarnServerFederationProtos.SubClusterInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getLastHeartBeat();
    }

    @Override
    public void setLastHeartBeat(long time) {
        this.maybeInitBuilder();
        this.builder.setLastHeartBeat(time);
    }

    @Override
    public SubClusterState getState() {
        YarnServerFederationProtos.SubClusterInfoProtoOrBuilder p;
        YarnServerFederationProtos.SubClusterInfoProtoOrBuilder subClusterInfoProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasState()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getState());
    }

    @Override
    public void setState(SubClusterState state) {
        this.maybeInitBuilder();
        if (state == null) {
            this.builder.clearState();
            return;
        }
        this.builder.setState(this.convertToProtoFormat(state));
    }

    @Override
    public long getLastStartTime() {
        YarnServerFederationProtos.SubClusterInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasLastStartTime() ? p.getLastStartTime() : 0L;
    }

    @Override
    public void setLastStartTime(long lastStartTime) {
        Preconditions.checkNotNull((Object)this.builder);
        this.builder.setLastStartTime(lastStartTime);
    }

    @Override
    public String getCapability() {
        YarnServerFederationProtos.SubClusterInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasCapability() ? p.getCapability() : null;
    }

    @Override
    public void setCapability(String capability) {
        this.maybeInitBuilder();
        if (capability == null) {
            this.builder.clearCapability();
            return;
        }
        this.builder.setCapability(capability);
    }

    private SubClusterId convertFromProtoFormat(YarnServerFederationProtos.SubClusterIdProto clusterId) {
        return new SubClusterIdPBImpl(clusterId);
    }

    private YarnServerFederationProtos.SubClusterIdProto convertToProtoFormat(SubClusterId clusterId) {
        return ((SubClusterIdPBImpl)clusterId).getProto();
    }

    private SubClusterState convertFromProtoFormat(YarnServerFederationProtos.SubClusterStateProto state) {
        return SubClusterState.valueOf(state.name());
    }

    private YarnServerFederationProtos.SubClusterStateProto convertToProtoFormat(SubClusterState state) {
        return YarnServerFederationProtos.SubClusterStateProto.valueOf(state.name());
    }
}

