/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;

public class AppAllocation {
    private Priority priority = null;
    private NodeId nodeId;
    private ContainerId containerId = null;
    private ActivityState appState = null;
    private String diagnostic = null;
    private String queueName = null;
    private List<ActivityNode> allocationAttempts;
    private long timestamp;

    public AppAllocation(Priority priority, NodeId nodeId, String queueName) {
        this.priority = priority;
        this.nodeId = nodeId;
        this.allocationAttempts = new ArrayList<ActivityNode>();
        this.queueName = queueName;
    }

    public void updateAppContainerStateAndTime(ContainerId containerId, ActivityState appState, long ts, String diagnostic) {
        this.timestamp = ts;
        this.containerId = containerId;
        this.appState = appState;
        this.diagnostic = diagnostic;
    }

    public void addAppAllocationActivity(String containerId, String priority, ActivityState state, String diagnostic, String type) {
        ActivityNode container = new ActivityNode(containerId, null, priority, state, diagnostic, type);
        this.allocationAttempts.add(container);
        this.appState = state == ActivityState.REJECTED ? ActivityState.SKIPPED : state;
    }

    public String getNodeId() {
        return this.nodeId.toString();
    }

    public String getQueueName() {
        return this.queueName;
    }

    public ActivityState getAppState() {
        return this.appState;
    }

    public String getPriority() {
        if (this.priority == null) {
            return null;
        }
        return this.priority.toString();
    }

    public String getContainerId() {
        if (this.containerId == null) {
            return null;
        }
        return this.containerId.toString();
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }

    public long getTime() {
        return this.timestamp;
    }

    public List<ActivityNode> getAllocationAttempts() {
        return this.allocationAttempts;
    }
}

