/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Comparator;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MetaCellComparator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@SuppressWarnings(value={"UNKNOWN"}, justification="Findbugs doesn't like the way we are negating the result of a compare in below")
public class CellComparatorImpl
implements CellComparator {
    private static final long serialVersionUID = 8186411895799094989L;
    public static final CellComparatorImpl COMPARATOR = new CellComparatorImpl();

    @Override
    public final int compare(Cell a, Cell b) {
        return this.compare(a, b, false);
    }

    @Override
    public int compare(Cell l, Cell r, boolean ignoreSequenceid) {
        int diff = 0;
        if (l instanceof KeyValue && r instanceof KeyValue) {
            diff = this.compareKeyValues((KeyValue)l, (KeyValue)r);
            if (diff != 0) {
                return diff;
            }
        } else if (l instanceof KeyValue && r instanceof ByteBufferKeyValue) {
            diff = this.compareKVVsBBKV((KeyValue)l, (ByteBufferKeyValue)r);
            if (diff != 0) {
                return diff;
            }
        } else if (l instanceof ByteBufferKeyValue && r instanceof KeyValue) {
            diff = this.compareKVVsBBKV((KeyValue)r, (ByteBufferKeyValue)l);
            if (diff != 0) {
                return -diff;
            }
        } else if (l instanceof ByteBufferKeyValue && r instanceof ByteBufferKeyValue) {
            diff = this.compareBBKV((ByteBufferKeyValue)l, (ByteBufferKeyValue)r);
            if (diff != 0) {
                return diff;
            }
        } else {
            short rightRowLength;
            short leftRowLength = l.getRowLength();
            diff = CellComparatorImpl.compareRows(l, leftRowLength, r, rightRowLength = r.getRowLength());
            if (diff != 0) {
                return diff;
            }
            diff = this.compareWithoutRow(l, r);
            if (diff != 0) {
                return diff;
            }
        }
        return ignoreSequenceid ? diff : Long.compare(r.getSequenceId(), l.getSequenceId());
    }

    private int compareKeyValues(KeyValue left, KeyValue right) {
        int rightFamilyPosition;
        short leftRowLength = left.getRowLength();
        short rightRowLength = right.getRowLength();
        int diff = Bytes.compareTo(left.getRowArray(), left.getRowOffset(), leftRowLength, right.getRowArray(), right.getRowOffset(), rightRowLength);
        if (diff != 0) {
            return diff;
        }
        int leftFamilyLengthPosition = left.getFamilyLengthPosition(leftRowLength);
        byte leftFamilyLength = left.getFamilyLength(leftFamilyLengthPosition);
        int leftKeyLength = left.getKeyLength();
        int leftQualifierLength = left.getQualifierLength(leftKeyLength, leftRowLength, leftFamilyLength);
        byte leftType = left.getTypeByte(leftKeyLength);
        if (leftType == KeyValue.Type.Minimum.getCode() && leftFamilyLength + leftQualifierLength == 0) {
            return 1;
        }
        int rightFamilyLengthPosition = right.getFamilyLengthPosition(rightRowLength);
        byte rightFamilyLength = right.getFamilyLength(rightFamilyLengthPosition);
        int rightKeyLength = right.getKeyLength();
        int rightQualifierLength = right.getQualifierLength(rightKeyLength, rightRowLength, rightFamilyLength);
        byte rightType = right.getTypeByte(rightKeyLength);
        if (rightType == KeyValue.Type.Minimum.getCode() && rightFamilyLength + rightQualifierLength == 0) {
            return -1;
        }
        int leftFamilyPosition = left.getFamilyOffset(leftFamilyLengthPosition);
        diff = this.compareFamilies(left, leftFamilyPosition, (int)leftFamilyLength, right, rightFamilyPosition = right.getFamilyOffset(rightFamilyLengthPosition), (int)rightFamilyLength);
        if (diff != 0) {
            return diff;
        }
        diff = Bytes.compareTo(left.getQualifierArray(), left.getQualifierOffset(leftFamilyPosition, leftFamilyLength), leftQualifierLength, right.getQualifierArray(), right.getQualifierOffset(rightFamilyPosition, rightFamilyLength), rightQualifierLength);
        if (diff != 0) {
            return diff;
        }
        diff = Long.compare(right.getTimestamp(rightKeyLength), left.getTimestamp(leftKeyLength));
        if (diff != 0) {
            return diff;
        }
        return (0xFF & rightType) - (0xFF & leftType);
    }

    private int compareBBKV(ByteBufferKeyValue left, ByteBufferKeyValue right) {
        int rightFamilyPosition;
        short leftRowLength = left.getRowLength();
        short rightRowLength = right.getRowLength();
        int diff = ByteBufferUtils.compareTo(left.getRowByteBuffer(), left.getRowPosition(), (int)leftRowLength, right.getRowByteBuffer(), right.getRowPosition(), (int)rightRowLength);
        if (diff != 0) {
            return diff;
        }
        int leftFamilyLengthPosition = left.getFamilyLengthPosition(leftRowLength);
        byte leftFamilyLength = left.getFamilyLength(leftFamilyLengthPosition);
        int leftKeyLength = left.getKeyLength();
        int leftQualifierLength = left.getQualifierLength(leftKeyLength, leftRowLength, leftFamilyLength);
        byte leftType = left.getTypeByte(leftKeyLength);
        if (leftType == KeyValue.Type.Minimum.getCode() && leftFamilyLength + leftQualifierLength == 0) {
            return 1;
        }
        int rightFamilyLengthPosition = right.getFamilyLengthPosition(rightRowLength);
        byte rightFamilyLength = right.getFamilyLength(rightFamilyLengthPosition);
        int rightKeyLength = right.getKeyLength();
        int rightQualifierLength = right.getQualifierLength(rightKeyLength, rightRowLength, rightFamilyLength);
        byte rightType = right.getTypeByte(rightKeyLength);
        if (rightType == KeyValue.Type.Minimum.getCode() && rightFamilyLength + rightQualifierLength == 0) {
            return -1;
        }
        int leftFamilyPosition = left.getFamilyPosition(leftFamilyLengthPosition);
        diff = this.compareFamilies(left, leftFamilyPosition, (int)leftFamilyLength, right, rightFamilyPosition = right.getFamilyPosition(rightFamilyLengthPosition), (int)rightFamilyLength);
        if (diff != 0) {
            return diff;
        }
        diff = ByteBufferUtils.compareTo(left.getQualifierByteBuffer(), left.getQualifierPosition(leftFamilyPosition, leftFamilyLength), leftQualifierLength, right.getQualifierByteBuffer(), right.getQualifierPosition(rightFamilyPosition, rightFamilyLength), rightQualifierLength);
        if (diff != 0) {
            return diff;
        }
        diff = Long.compare(right.getTimestamp(rightKeyLength), left.getTimestamp(leftKeyLength));
        if (diff != 0) {
            return diff;
        }
        return (0xFF & rightType) - (0xFF & leftType);
    }

    private int compareKVVsBBKV(KeyValue left, ByteBufferKeyValue right) {
        int rightFamilyPosition;
        short leftRowLength = left.getRowLength();
        short rightRowLength = right.getRowLength();
        int diff = ByteBufferUtils.compareTo(left.getRowArray(), left.getRowOffset(), (int)leftRowLength, right.getRowByteBuffer(), right.getRowPosition(), (int)rightRowLength);
        if (diff != 0) {
            return diff;
        }
        int leftFamilyLengthPosition = left.getFamilyLengthPosition(leftRowLength);
        byte leftFamilyLength = left.getFamilyLength(leftFamilyLengthPosition);
        int leftKeyLength = left.getKeyLength();
        int leftQualifierLength = left.getQualifierLength(leftKeyLength, leftRowLength, leftFamilyLength);
        byte leftType = left.getTypeByte(leftKeyLength);
        if (leftType == KeyValue.Type.Minimum.getCode() && leftFamilyLength + leftQualifierLength == 0) {
            return 1;
        }
        int rightFamilyLengthPosition = right.getFamilyLengthPosition(rightRowLength);
        byte rightFamilyLength = right.getFamilyLength(rightFamilyLengthPosition);
        int rightKeyLength = right.getKeyLength();
        int rightQualifierLength = right.getQualifierLength(rightKeyLength, rightRowLength, rightFamilyLength);
        byte rightType = right.getTypeByte(rightKeyLength);
        if (rightType == KeyValue.Type.Minimum.getCode() && rightFamilyLength + rightQualifierLength == 0) {
            return -1;
        }
        int leftFamilyPosition = left.getFamilyOffset(leftFamilyLengthPosition);
        diff = this.compareFamilies(left, leftFamilyPosition, (int)leftFamilyLength, right, rightFamilyPosition = right.getFamilyPosition(rightFamilyLengthPosition), (int)rightFamilyLength);
        if (diff != 0) {
            return diff;
        }
        diff = ByteBufferUtils.compareTo(left.getQualifierArray(), left.getQualifierOffset(leftFamilyPosition, leftFamilyLength), leftQualifierLength, right.getQualifierByteBuffer(), right.getQualifierPosition(rightFamilyPosition, rightFamilyLength), rightQualifierLength);
        if (diff != 0) {
            return diff;
        }
        diff = Long.compare(right.getTimestamp(rightKeyLength), left.getTimestamp(leftKeyLength));
        if (diff != 0) {
            return diff;
        }
        return (0xFF & rightType) - (0xFF & leftType);
    }

    public final int compareColumns(Cell left, Cell right) {
        int diff = this.compareFamilies(left, right);
        if (diff != 0) {
            return diff;
        }
        return this.compareQualifiers(left, right);
    }

    private int compareColumns(Cell left, int leftFamLen, int leftQualLen, Cell right, int rightFamLen, int rightQualLen) {
        int diff = this.compareFamilies(left, leftFamLen, right, rightFamLen);
        if (diff != 0) {
            return diff;
        }
        return this.compareQualifiers(left, leftQualLen, right, rightQualLen);
    }

    protected int compareFamilies(Cell left, int leftFamLen, Cell right, int rightFamLen) {
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getFamilyByteBuffer(), ((ByteBufferExtendedCell)left).getFamilyPosition(), leftFamLen, ((ByteBufferExtendedCell)right).getFamilyByteBuffer(), ((ByteBufferExtendedCell)right).getFamilyPosition(), rightFamLen);
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getFamilyByteBuffer(), ((ByteBufferExtendedCell)left).getFamilyPosition(), leftFamLen, right.getFamilyArray(), right.getFamilyOffset(), rightFamLen);
        }
        if (right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(left.getFamilyArray(), left.getFamilyOffset(), leftFamLen, ((ByteBufferExtendedCell)right).getFamilyByteBuffer(), ((ByteBufferExtendedCell)right).getFamilyPosition(), rightFamLen);
        }
        return Bytes.compareTo(left.getFamilyArray(), left.getFamilyOffset(), leftFamLen, right.getFamilyArray(), right.getFamilyOffset(), rightFamLen);
    }

    private final int compareQualifiers(Cell left, int leftQualLen, Cell right, int rightQualLen) {
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getQualifierByteBuffer(), ((ByteBufferExtendedCell)left).getQualifierPosition(), leftQualLen, ((ByteBufferExtendedCell)right).getQualifierByteBuffer(), ((ByteBufferExtendedCell)right).getQualifierPosition(), rightQualLen);
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getQualifierByteBuffer(), ((ByteBufferExtendedCell)left).getQualifierPosition(), leftQualLen, right.getQualifierArray(), right.getQualifierOffset(), rightQualLen);
        }
        if (right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(left.getQualifierArray(), left.getQualifierOffset(), leftQualLen, ((ByteBufferExtendedCell)right).getQualifierByteBuffer(), ((ByteBufferExtendedCell)right).getQualifierPosition(), rightQualLen);
        }
        return Bytes.compareTo(left.getQualifierArray(), left.getQualifierOffset(), leftQualLen, right.getQualifierArray(), right.getQualifierOffset(), rightQualLen);
    }

    @Override
    public final int compareFamilies(Cell left, Cell right) {
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getFamilyByteBuffer(), ((ByteBufferExtendedCell)left).getFamilyPosition(), (int)left.getFamilyLength(), ((ByteBufferExtendedCell)right).getFamilyByteBuffer(), ((ByteBufferExtendedCell)right).getFamilyPosition(), (int)right.getFamilyLength());
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getFamilyByteBuffer(), ((ByteBufferExtendedCell)left).getFamilyPosition(), (int)left.getFamilyLength(), right.getFamilyArray(), right.getFamilyOffset(), (int)right.getFamilyLength());
        }
        if (right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(left.getFamilyArray(), left.getFamilyOffset(), (int)left.getFamilyLength(), ((ByteBufferExtendedCell)right).getFamilyByteBuffer(), ((ByteBufferExtendedCell)right).getFamilyPosition(), (int)right.getFamilyLength());
        }
        return Bytes.compareTo(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), right.getFamilyArray(), right.getFamilyOffset(), right.getFamilyLength());
    }

    protected int compareFamilies(KeyValue left, int leftFamilyPosition, int leftFamilyLength, KeyValue right, int rightFamilyPosition, int rightFamilyLength) {
        return Bytes.compareTo(left.getFamilyArray(), leftFamilyPosition, leftFamilyLength, right.getFamilyArray(), rightFamilyPosition, rightFamilyLength);
    }

    protected int compareFamilies(ByteBufferKeyValue left, int leftFamilyPosition, int leftFamilyLength, ByteBufferKeyValue right, int rightFamilyPosition, int rightFamilyLength) {
        return ByteBufferUtils.compareTo(left.getFamilyByteBuffer(), leftFamilyPosition, leftFamilyLength, right.getFamilyByteBuffer(), rightFamilyPosition, rightFamilyLength);
    }

    protected int compareFamilies(KeyValue left, int leftFamilyPosition, int leftFamilyLength, ByteBufferKeyValue right, int rightFamilyPosition, int rightFamilyLength) {
        return ByteBufferUtils.compareTo(left.getFamilyArray(), leftFamilyPosition, leftFamilyLength, right.getFamilyByteBuffer(), rightFamilyPosition, rightFamilyLength);
    }

    static int compareQualifiers(KeyValue left, KeyValue right) {
        short leftRowLength = left.getRowLength();
        short rightRowLength = right.getRowLength();
        int leftFamilyLengthPosition = left.getFamilyLengthPosition(leftRowLength);
        byte leftFamilyLength = left.getFamilyLength(leftFamilyLengthPosition);
        int leftKeyLength = left.getKeyLength();
        int leftQualifierLength = left.getQualifierLength(leftKeyLength, leftRowLength, leftFamilyLength);
        int rightFamilyLengthPosition = right.getFamilyLengthPosition(rightRowLength);
        byte rightFamilyLength = right.getFamilyLength(rightFamilyLengthPosition);
        int rightKeyLength = right.getKeyLength();
        int rightQualifierLength = right.getQualifierLength(rightKeyLength, rightRowLength, rightFamilyLength);
        int leftFamilyOffset = left.getFamilyOffset(leftFamilyLengthPosition);
        int rightFamilyOffset = right.getFamilyOffset(rightFamilyLengthPosition);
        return Bytes.compareTo(left.getQualifierArray(), leftFamilyOffset + leftFamilyLength, leftQualifierLength, right.getQualifierArray(), rightFamilyOffset + rightFamilyLength, rightQualifierLength);
    }

    static int compareQualifiers(KeyValue left, ByteBufferKeyValue right) {
        short leftRowLength = left.getRowLength();
        short rightRowLength = right.getRowLength();
        int leftFamilyLengthPosition = left.getFamilyLengthPosition(leftRowLength);
        byte leftFamilyLength = left.getFamilyLength(leftFamilyLengthPosition);
        int leftKeyLength = left.getKeyLength();
        int leftQualifierLength = left.getQualifierLength(leftKeyLength, leftRowLength, leftFamilyLength);
        int rightFamilyLengthPosition = right.getFamilyLengthPosition(rightRowLength);
        byte rightFamilyLength = right.getFamilyLength(rightFamilyLengthPosition);
        int rightKeyLength = right.getKeyLength();
        int rightQualifierLength = right.getQualifierLength(rightKeyLength, rightRowLength, rightFamilyLength);
        int leftFamilyOffset = left.getFamilyOffset(leftFamilyLengthPosition);
        int rightFamilyPosition = right.getFamilyPosition(rightFamilyLengthPosition);
        return ByteBufferUtils.compareTo(left.getQualifierArray(), leftFamilyOffset + leftFamilyLength, leftQualifierLength, right.getQualifierByteBuffer(), rightFamilyPosition + rightFamilyLength, rightQualifierLength);
    }

    static int compareQualifiers(ByteBufferKeyValue left, KeyValue right) {
        short leftRowLength = left.getRowLength();
        short rightRowLength = right.getRowLength();
        int leftFamilyLengthPosition = left.getFamilyLengthPosition(leftRowLength);
        byte leftFamilyLength = left.getFamilyLength(leftFamilyLengthPosition);
        int leftKeyLength = left.getKeyLength();
        int leftQualifierLength = left.getQualifierLength(leftKeyLength, leftRowLength, leftFamilyLength);
        int rightFamilyLengthPosition = right.getFamilyLengthPosition(rightRowLength);
        byte rightFamilyLength = right.getFamilyLength(rightFamilyLengthPosition);
        int rightKeyLength = right.getKeyLength();
        int rightQualifierLength = right.getQualifierLength(rightKeyLength, rightRowLength, rightFamilyLength);
        int leftFamilyPosition = left.getFamilyPosition(leftFamilyLengthPosition);
        int rightFamilyOffset = right.getFamilyOffset(rightFamilyLengthPosition);
        return ByteBufferUtils.compareTo(left.getQualifierByteBuffer(), leftFamilyPosition + leftFamilyLength, leftQualifierLength, right.getQualifierArray(), rightFamilyOffset + rightFamilyLength, rightQualifierLength);
    }

    static int compareQualifiers(ByteBufferKeyValue left, ByteBufferKeyValue right) {
        short leftRowLength = left.getRowLength();
        short rightRowLength = right.getRowLength();
        int leftFamilyLengthPosition = left.getFamilyLengthPosition(leftRowLength);
        byte leftFamilyLength = left.getFamilyLength(leftFamilyLengthPosition);
        int leftKeyLength = left.getKeyLength();
        int leftQualifierLength = left.getQualifierLength(leftKeyLength, leftRowLength, leftFamilyLength);
        int rightFamilyLengthPosition = right.getFamilyLengthPosition(rightRowLength);
        byte rightFamilyLength = right.getFamilyLength(rightFamilyLengthPosition);
        int rightKeyLength = right.getKeyLength();
        int rightQualifierLength = right.getQualifierLength(rightKeyLength, rightRowLength, rightFamilyLength);
        int leftFamilyPosition = left.getFamilyPosition(leftFamilyLengthPosition);
        int rightFamilyPosition = right.getFamilyPosition(rightFamilyLengthPosition);
        return ByteBufferUtils.compareTo(left.getQualifierByteBuffer(), leftFamilyPosition + leftFamilyLength, leftQualifierLength, right.getQualifierByteBuffer(), rightFamilyPosition + rightFamilyLength, rightQualifierLength);
    }

    @Override
    public final int compareQualifiers(Cell left, Cell right) {
        if (left instanceof ByteBufferKeyValue && right instanceof ByteBufferKeyValue) {
            return CellComparatorImpl.compareQualifiers((ByteBufferKeyValue)left, (ByteBufferKeyValue)right);
        }
        if (left instanceof KeyValue && right instanceof KeyValue) {
            return CellComparatorImpl.compareQualifiers((KeyValue)left, (KeyValue)right);
        }
        if (left instanceof KeyValue && right instanceof ByteBufferKeyValue) {
            return CellComparatorImpl.compareQualifiers((KeyValue)left, (ByteBufferKeyValue)right);
        }
        if (left instanceof ByteBufferKeyValue && right instanceof KeyValue) {
            return CellComparatorImpl.compareQualifiers((ByteBufferKeyValue)left, (KeyValue)right);
        }
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getQualifierByteBuffer(), ((ByteBufferExtendedCell)left).getQualifierPosition(), left.getQualifierLength(), ((ByteBufferExtendedCell)right).getQualifierByteBuffer(), ((ByteBufferExtendedCell)right).getQualifierPosition(), right.getQualifierLength());
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getQualifierByteBuffer(), ((ByteBufferExtendedCell)left).getQualifierPosition(), left.getQualifierLength(), right.getQualifierArray(), right.getQualifierOffset(), right.getQualifierLength());
        }
        if (right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), ((ByteBufferExtendedCell)right).getQualifierByteBuffer(), ((ByteBufferExtendedCell)right).getQualifierPosition(), right.getQualifierLength());
        }
        return Bytes.compareTo(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), right.getQualifierArray(), right.getQualifierOffset(), right.getQualifierLength());
    }

    @Override
    public int compareRows(Cell left, Cell right) {
        return CellComparatorImpl.compareRows(left, left.getRowLength(), right, right.getRowLength());
    }

    static int compareRows(Cell left, int leftRowLength, Cell right, int rightRowLength) {
        if (left == right) {
            return 0;
        }
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getRowByteBuffer(), ((ByteBufferExtendedCell)left).getRowPosition(), leftRowLength, ((ByteBufferExtendedCell)right).getRowByteBuffer(), ((ByteBufferExtendedCell)right).getRowPosition(), rightRowLength);
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getRowByteBuffer(), ((ByteBufferExtendedCell)left).getRowPosition(), leftRowLength, right.getRowArray(), right.getRowOffset(), rightRowLength);
        }
        if (right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(left.getRowArray(), left.getRowOffset(), leftRowLength, ((ByteBufferExtendedCell)right).getRowByteBuffer(), ((ByteBufferExtendedCell)right).getRowPosition(), rightRowLength);
        }
        return Bytes.compareTo(left.getRowArray(), left.getRowOffset(), leftRowLength, right.getRowArray(), right.getRowOffset(), rightRowLength);
    }

    @Override
    public int compareRows(Cell left, byte[] right, int roffset, int rlength) {
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getRowByteBuffer(), ((ByteBufferExtendedCell)left).getRowPosition(), (int)left.getRowLength(), right, roffset, rlength);
        }
        return Bytes.compareTo(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right, roffset, rlength);
    }

    @Override
    public final int compareWithoutRow(Cell left, Cell right) {
        byte lFamLength = left.getFamilyLength();
        byte rFamLength = right.getFamilyLength();
        int lQualLength = left.getQualifierLength();
        int rQualLength = right.getQualifierLength();
        if (lFamLength + lQualLength == 0 && left.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
            return 1;
        }
        if (rFamLength + rQualLength == 0 && right.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
            return -1;
        }
        if (lFamLength != rFamLength) {
            return this.compareFamilies(left, lFamLength, right, rFamLength);
        }
        int diff = this.compareColumns(left, lFamLength, lQualLength, right, rFamLength, rQualLength);
        if (diff != 0) {
            return diff;
        }
        diff = this.compareTimestamps(left.getTimestamp(), right.getTimestamp());
        if (diff != 0) {
            return diff;
        }
        return (0xFF & right.getTypeByte()) - (0xFF & left.getTypeByte());
    }

    @Override
    public int compareTimestamps(Cell left, Cell right) {
        return this.compareTimestamps(left.getTimestamp(), right.getTimestamp());
    }

    @Override
    public int compareTimestamps(long ltimestamp, long rtimestamp) {
        return Long.compare(rtimestamp, ltimestamp);
    }

    public Comparator getSimpleComparator() {
        return this;
    }

    public static CellComparator getCellComparator(TableName tableName) {
        return CellComparatorImpl.getCellComparator(tableName.toBytes());
    }

    public static CellComparator getCellComparator(byte[] tableName) {
        return Bytes.equals(tableName, TableName.META_TABLE_NAME.toBytes()) ? MetaCellComparator.META_COMPARATOR : COMPARATOR;
    }
}

