/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.joni;

import org.apache.hadoop.hbase.shaded.org.jcodings.Encoding;
import org.apache.hadoop.hbase.shaded.org.joni.Analyser;
import org.apache.hadoop.hbase.shaded.org.joni.Config;
import org.apache.hadoop.hbase.shaded.org.joni.Regex;
import org.apache.hadoop.hbase.shaded.org.joni.ast.AnchorNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.BackRefNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.CClassNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.CTypeNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.CallNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.EncloseNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.ListNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.Node;
import org.apache.hadoop.hbase.shaded.org.joni.ast.QuantifierNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.StringNode;
import org.apache.hadoop.hbase.shaded.org.joni.exception.ErrorMessages;
import org.apache.hadoop.hbase.shaded.org.joni.exception.InternalException;
import org.apache.hadoop.hbase.shaded.org.joni.exception.SyntaxException;

abstract class Compiler
implements ErrorMessages {
    protected final Analyser analyser;
    protected final Encoding enc;
    protected final Regex regex;

    protected Compiler(Analyser analyser) {
        this.analyser = analyser;
        this.regex = analyser.regex;
        this.enc = this.regex.enc;
    }

    final void compile(Node root) {
        this.prepare();
        this.compileTree(root);
        this.finish();
    }

    protected abstract void prepare();

    protected abstract void finish();

    protected abstract void compileAltNode(ListNode var1);

    private void compileStringRawNode(StringNode sn) {
        if (sn.length() <= 0) {
            return;
        }
        this.addCompileString(sn.bytes, sn.p, 1, sn.length(), false);
    }

    private void compileStringNode(StringNode node) {
        int prev;
        StringNode sn = node;
        if (sn.length() <= 0) {
            return;
        }
        boolean ambig = sn.isAmbig();
        int p = prev = sn.p;
        int end = sn.end;
        byte[] bytes = sn.bytes;
        int prevLen = this.enc.length(bytes, p, end);
        p += prevLen;
        int blen = prevLen;
        while (p < end) {
            int len = this.enc.length(bytes, p, end);
            if (len == prevLen || ambig) {
                blen += len;
            } else {
                this.addCompileString(bytes, prev, prevLen, blen, ambig);
                prev = p;
                blen = len;
                prevLen = len;
            }
            p += len;
        }
        this.addCompileString(bytes, prev, prevLen, blen, ambig);
    }

    protected abstract void addCompileString(byte[] var1, int var2, int var3, int var4, boolean var5);

    protected abstract void compileCClassNode(CClassNode var1);

    protected abstract void compileCTypeNode(CTypeNode var1);

    protected abstract void compileAnyCharNode();

    protected abstract void compileCallNode(CallNode var1);

    protected abstract void compileBackrefNode(BackRefNode var1);

    protected abstract void compileCECQuantifierNode(QuantifierNode var1);

    protected abstract void compileNonCECQuantifierNode(QuantifierNode var1);

    protected abstract void compileOptionNode(EncloseNode var1);

    protected abstract void compileEncloseNode(EncloseNode var1);

    protected abstract void compileAnchorNode(AnchorNode var1);

    protected final void compileTree(Node node) {
        switch (node.getType()) {
            case 8: {
                ListNode lin = (ListNode)node;
                do {
                    this.compileTree(lin.value);
                } while ((lin = lin.tail) != null);
                break;
            }
            case 9: {
                this.compileAltNode((ListNode)node);
                break;
            }
            case 0: {
                StringNode sn = (StringNode)node;
                if (sn.isRaw()) {
                    this.compileStringRawNode(sn);
                    break;
                }
                this.compileStringNode(sn);
                break;
            }
            case 1: {
                this.compileCClassNode((CClassNode)node);
                break;
            }
            case 2: {
                this.compileCTypeNode((CTypeNode)node);
                break;
            }
            case 3: {
                this.compileAnyCharNode();
                break;
            }
            case 4: {
                this.compileBackrefNode((BackRefNode)node);
                break;
            }
            case 10: {
                if (!Config.USE_SUBEXP_CALL) break;
                this.compileCallNode((CallNode)node);
                break;
            }
            case 5: {
                if (Config.USE_CEC) {
                    this.compileCECQuantifierNode((QuantifierNode)node);
                    break;
                }
                this.compileNonCECQuantifierNode((QuantifierNode)node);
                break;
            }
            case 6: {
                EncloseNode enode = (EncloseNode)node;
                if (enode.isOption()) {
                    this.compileOptionNode(enode);
                    break;
                }
                this.compileEncloseNode(enode);
                break;
            }
            case 7: {
                this.compileAnchorNode((AnchorNode)node);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    protected final void compileTreeNTimes(Node node, int n) {
        for (int i = 0; i < n; ++i) {
            this.compileTree(node);
        }
    }

    protected void newSyntaxException(String message) {
        throw new SyntaxException(message);
    }

    protected void newInternalException(String message) {
        throw new InternalException(message);
    }
}

