/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.apache.hadoop.hbase.shaded.org.agrona.BitUtil;

public class IntArrayQueue
extends AbstractQueue<Integer>
implements Serializable {
    public static final int DEFAULT_NULL_VALUE = Integer.MIN_VALUE;
    public static final int MIN_CAPACITY = 8;
    private static final long serialVersionUID = 8043508567156267834L;
    private final boolean shouldAvoidAllocation;
    private int head;
    private int tail;
    private final int nullValue;
    private int[] elements;
    private IntIterator iterator;

    public IntArrayQueue() {
        this(8, Integer.MIN_VALUE, true);
    }

    public IntArrayQueue(int nullValue) {
        this(8, nullValue, true);
    }

    public IntArrayQueue(int initialCapacity, int nullValue) {
        this(initialCapacity, nullValue, true);
    }

    public IntArrayQueue(int initialCapacity, int nullValue, boolean shouldAvoidAllocation) {
        this.nullValue = nullValue;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        if (initialCapacity < 8) {
            throw new IllegalArgumentException("initial capacity < MIN_INITIAL_CAPACITY : " + initialCapacity);
        }
        int capacity = BitUtil.findNextPositivePowerOfTwo(initialCapacity);
        if (capacity < 8) {
            throw new IllegalArgumentException("invalid initial capacity: " + initialCapacity);
        }
        this.elements = new int[capacity];
        Arrays.fill(this.elements, nullValue);
    }

    public int nullValue() {
        return this.nullValue;
    }

    public int capacity() {
        return this.elements.length;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public void clear() {
        if (this.head != this.tail) {
            Arrays.fill(this.elements, this.nullValue);
            this.head = 0;
            this.tail = 0;
        }
    }

    @Override
    public boolean offer(Integer element) {
        return this.offerInt(element);
    }

    public boolean offerInt(int element) {
        if (this.nullValue == element) {
            throw new NullPointerException();
        }
        this.elements[this.tail] = element;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.increaseCapacity();
        }
        return true;
    }

    @Override
    public boolean add(Integer element) {
        return this.offerInt(element);
    }

    public boolean addInt(int element) {
        return this.offerInt(element);
    }

    @Override
    public Integer peek() {
        int element = this.elements[this.head];
        return element == this.nullValue ? null : Integer.valueOf(element);
    }

    public int peekInt() {
        return this.elements[this.head];
    }

    @Override
    public Integer poll() {
        int element = this.pollInt();
        return element == this.nullValue ? null : Integer.valueOf(element);
    }

    public int pollInt() {
        int element = this.elements[this.head];
        if (this.nullValue == element) {
            return this.nullValue;
        }
        this.elements[this.head] = this.nullValue;
        this.head = this.head + 1 & this.elements.length - 1;
        return element;
    }

    @Override
    public Integer remove() {
        int element = this.pollInt();
        if (this.nullValue == element) {
            throw new NoSuchElementException();
        }
        return element;
    }

    @Override
    public Integer element() {
        int element = this.elements[this.head];
        if (this.nullValue == element) {
            throw new NoSuchElementException();
        }
        return element;
    }

    public int elementInt() {
        int element = this.elements[this.head];
        if (this.nullValue == element) {
            throw new NoSuchElementException();
        }
        return element;
    }

    public int removeInt() {
        int element = this.pollInt();
        if (this.nullValue == element) {
            throw new NoSuchElementException();
        }
        return element;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = this.head;
        while (i != this.tail) {
            sb.append(this.elements[i]).append(", ");
            i = i + 1 & this.elements.length - 1;
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void forEach(Consumer<? super Integer> action) {
        int i = this.head;
        while (i != this.tail) {
            action.accept((Integer)this.elements[i]);
            i = i + 1 & this.elements.length - 1;
        }
    }

    public void forEachInt(IntConsumer action) {
        int i = this.head;
        while (i != this.tail) {
            action.accept(this.elements[i]);
            i = i + 1 & this.elements.length - 1;
        }
    }

    public IntIterator iterator() {
        IntIterator iterator = this.iterator;
        if (null == iterator) {
            iterator = new IntIterator();
            if (this.shouldAvoidAllocation) {
                this.iterator = iterator;
            }
        }
        return iterator.reset();
    }

    private void increaseCapacity() {
        int oldHead = this.head;
        int oldCapacity = this.elements.length;
        int toEndOfArray = oldCapacity - oldHead;
        int newCapacity = oldCapacity << 1;
        if (newCapacity < 8) {
            throw new IllegalStateException("max capacity reached");
        }
        int[] array = new int[newCapacity];
        Arrays.fill(array, oldCapacity, newCapacity, this.nullValue);
        System.arraycopy(this.elements, oldHead, array, 0, toEndOfArray);
        System.arraycopy(this.elements, 0, array, toEndOfArray, oldHead);
        this.elements = array;
        this.head = 0;
        this.tail = oldCapacity;
    }

    public final class IntIterator
    implements Iterator<Integer>,
    Serializable {
        private static final long serialVersionUID = -7596692870537894897L;
        private int index;

        IntIterator reset() {
            this.index = IntArrayQueue.this.head;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.index != IntArrayQueue.this.tail;
        }

        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            if (this.index == IntArrayQueue.this.tail) {
                throw new NoSuchElementException();
            }
            int element = IntArrayQueue.this.elements[this.index];
            this.index = this.index + 1 & IntArrayQueue.this.elements.length - 1;
            return element;
        }
    }
}

