/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.BooleanStateStore;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotCleanupProtos;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SnapshotCleanupStateStore
extends BooleanStateStore {
    public static final String STATE_NAME = "snapshot_cleanup_enabled";

    public SnapshotCleanupStateStore(MasterRegion masterRegion, ZKWatcher watcher) throws IOException, KeeperException, DeserializationException {
        super(masterRegion, STATE_NAME, watcher, watcher.getZNodePaths().snapshotCleanupZNode);
    }

    @Override
    protected byte[] toByteArray(boolean isSnapshotCleanupEnabled) {
        SnapshotCleanupProtos.SnapshotCleanupState.Builder builder = SnapshotCleanupProtos.SnapshotCleanupState.newBuilder();
        builder.setSnapshotCleanupEnabled(isSnapshotCleanupEnabled);
        return ProtobufUtil.prependPBMagic(builder.build().toByteArray());
    }

    @Override
    protected boolean parseFrom(byte[] pbBytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix(pbBytes);
        SnapshotCleanupProtos.SnapshotCleanupState.Builder builder = SnapshotCleanupProtos.SnapshotCleanupState.newBuilder();
        try {
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom(builder, pbBytes, magicLen, pbBytes.length - magicLen);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return builder.build().getSnapshotCleanupEnabled();
    }
}

