/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.ServerRemoteProcedure;
import org.apache.hadoop.hbase.master.procedure.SnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.FailedRemoteDispatchException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.regionserver.SnapshotVerifyCallable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SnapshotVerifyProcedure
extends ServerRemoteProcedure
implements TableProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotVerifyProcedure.class);
    private SnapshotProtos.SnapshotDescription snapshot;
    private RegionInfo region;
    private RetryCounter retryCounter;

    public SnapshotVerifyProcedure() {
    }

    public SnapshotVerifyProcedure(SnapshotProtos.SnapshotDescription snapshot, RegionInfo region) {
        this.snapshot = snapshot;
        this.region = region;
    }

    @Override
    protected void rollback(MasterProcedureEnv env) {
    }

    @Override
    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean complete(MasterProcedureEnv env, Throwable error) {
        boolean isProcedureCompleted = false;
        try {
            if (error != null) {
                Throwable remoteEx;
                if (error instanceof RemoteProcedureException && (remoteEx = this.unwrapRemoteProcedureException((RemoteProcedureException)error)) instanceof CorruptedSnapshotException) {
                    isProcedureCompleted = true;
                    SnapshotProcedure parent = env.getMasterServices().getMasterProcedureExecutor().getProcedure(SnapshotProcedure.class, this.getParentProcId());
                    if (parent != null) {
                        parent.markSnapshotCorrupted();
                    }
                }
            } else {
                isProcedureCompleted = true;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed create corrupted snapshot flag file for snapshot={}, region={}", new Object[]{this.snapshot.getName(), this.region, e});
            this.setFailure("verify-snapshot", e);
        }
        finally {
            env.getMasterServices().getSnapshotManager().releaseSnapshotVerifyWorker(this, this.targetServer);
        }
        return isProcedureCompleted;
    }

    private Throwable unwrapRemoteProcedureException(RemoteProcedureException e) {
        return e.getCause();
    }

    @Override
    protected synchronized Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        try {
            SnapshotProcedure parent;
            if (this.state == MasterProcedureProtos.ServerRemoteProcedureState.SERVER_REMOTE_PROCEDURE_DISPATCH && (parent = env.getMasterServices().getMasterProcedureExecutor().getProcedure(SnapshotProcedure.class, this.getParentProcId())) != null && parent.isSnapshotCorrupted()) {
                return null;
            }
            if (this.state == MasterProcedureProtos.ServerRemoteProcedureState.SERVER_REMOTE_PROCEDURE_DISPATCH && this.targetServer == null) {
                this.targetServer = env.getMasterServices().getSnapshotManager().acquireSnapshotVerifyWorker(this);
            }
            Procedure<MasterProcedureEnv>[] res = super.execute(env);
            if (this.state == MasterProcedureProtos.ServerRemoteProcedureState.SERVER_REMOTE_PROCEDURE_DISPATCH) {
                this.targetServer = null;
                throw new FailedRemoteDispatchException("Failed sent request");
            }
            return res;
        }
        catch (IOException e) {
            if (this.retryCounter == null) {
                this.retryCounter = ProcedureUtil.createRetryCounter(env.getMasterConfiguration());
            }
            long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
            LOG.warn("Failed to get snapshot verify result , wait {} ms to retry", (Object)backoff, (Object)e);
            this.setTimeout(Math.toIntExact(backoff));
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            this.skipPersistence();
            throw new ProcedureSuspendedException();
        }
    }

    @Override
    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront(this);
        return false;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SnapshotVerifyProcedureStateData.Builder builder = MasterProcedureProtos.SnapshotVerifyProcedureStateData.newBuilder();
        builder.setSnapshot(this.snapshot).setRegion(ProtobufUtil.toRegionInfo(this.region)).setState(this.state);
        if (this.targetServer != null) {
            builder.setTargetServer(ProtobufUtil.toServerName(this.targetServer));
        }
        if (this.remoteError != null) {
            ErrorHandlingProtos.ForeignExceptionMessage fem = ForeignExceptionUtil.toProtoForeignException(this.remoteError);
            builder.setError(fem);
        }
        serializer.serialize(builder.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SnapshotVerifyProcedureStateData data = serializer.deserialize(MasterProcedureProtos.SnapshotVerifyProcedureStateData.class);
        this.snapshot = data.getSnapshot();
        this.region = ProtobufUtil.toRegionInfo(data.getRegion());
        this.state = data.getState();
        if (data.hasTargetServer()) {
            this.targetServer = ProtobufUtil.toServerName(data.getTargetServer());
        }
        if (data.hasError()) {
            this.remoteError = ForeignExceptionUtil.toException(data.getError());
        }
    }

    @Override
    protected void toStringClassDetails(StringBuilder builder) {
        builder.append(this.getClass().getSimpleName()).append(", snapshot=").append(this.snapshot.getName());
        if (this.targetServer != null) {
            builder.append(", targetServer=").append(this.targetServer);
        }
    }

    @Override
    public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv env, ServerName serverName) {
        MasterProcedureProtos.SnapshotVerifyParameter.Builder builder = MasterProcedureProtos.SnapshotVerifyParameter.newBuilder();
        builder.setSnapshot(this.snapshot).setRegion(ProtobufUtil.toRegionInfo(this.region));
        return Optional.of(new RSProcedureDispatcher.ServerOperation(this, this.getProcId(), SnapshotVerifyCallable.class, builder.build().toByteArray(), env.getMasterServices().getMasterActiveTime()));
    }

    @Override
    public TableName getTableName() {
        return TableName.valueOf(this.snapshot.getTable());
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.SNAPSHOT;
    }

    public ServerName getServerName() {
        return this.targetServer;
    }
}

